% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/52_check_parameters_functions.R
\name{check_adduct_table}
\alias{check_adduct_table}
\title{Validate the Adduct Table}
\usage{
check_adduct_table(adduct.table)
}
\arguments{
\item{adduct.table}{A data frame containing information about adducts. The table must have two columns: `adduct` (character) and `mz` (numeric).}
}
\value{
The function does not return a value but throws an error if the adduct table is invalid.
}
\description{
This function checks whether the input adduct table is valid by ensuring it is a data frame and contains the required columns (`adduct` and `mz`). It also validates the data types of the columns and checks for any missing values.
}
\details{
The function performs several checks on the `adduct.table`:
* Ensures that the input is a data frame.
* Confirms the presence of the required columns: `adduct` (character) and `mz` (numeric).
* Verifies that the `adduct` column is of character type and the `mz` column is numeric.
* Checks for missing values (`NA`) in either column.

If any of these conditions are not met, the function throws an error with a message explaining the issue.
}
\examples{
\dontrun{
# Example of a valid adduct table
adduct_table <- data.frame(
  adduct = c("(M+H)+", "(M+Na)+"),
  mz = c(1.0073, 22.9893)
)

# Validate the adduct table
check_adduct_table(adduct_table)

# Example of an invalid adduct table (missing 'mz' column)
invalid_table <- data.frame(
  adduct = c("(M+H)+", "(M+Na)+")
)

check_adduct_table(invalid_table) # This will throw an error
}

}
