% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_zzz.R
\name{calculate_total_score}
\alias{calculate_total_score}
\title{Calculate the Total Annotation Score}
\usage{
calculate_total_score(
  mz.match.score,
  RT.match.score,
  SS,
  ms1.match.weight = 0.25,
  rt.match.weight = 0.25,
  ms2.match.weight = 0.5,
  based_on = c("ms1", "rt", "ms2")
)
}
\arguments{
\item{mz.match.score}{Numeric vector. The m/z match scores.}

\item{RT.match.score}{Numeric vector. The retention time (RT) match scores.}

\item{SS}{Numeric vector. The MS2 spectral similarity (SS) scores.}

\item{ms1.match.weight}{Numeric. The weight assigned to the MS1 (m/z) match score. Default is 0.25.}

\item{rt.match.weight}{Numeric. The weight assigned to the RT match score. Default is 0.25.}

\item{ms2.match.weight}{Numeric. The weight assigned to the MS2 (spectral similarity) match score. Default is 0.5.}

\item{based_on}{Character vector. Specifies the criteria to base the total score on. Can include `"ms1"`, `"rt"`, and/or `"ms2"`. Default is `c("ms1", "rt", "ms2")`.}
}
\value{
A numeric vector representing the total score for each match, computed as the weighted sum of m/z, RT, and MS2 scores.
}
\description{
This function calculates the total annotation score based on the matching scores for m/z, retention time (RT), and spectral similarity (SS). The total score is calculated as a weighted sum of these matching scores, with weights determined by the `based_on` argument.
}
\details{
The function calculates the total score by applying weights to the individual match scores (`mz.match.score`, `RT.match.score`, `SS`). If the `based_on` argument specifies only one or two matching criteria (e.g., `"ms1"` or `"ms1"`, `"rt"`), the weights are adjusted accordingly.

The weights for `ms1.match.weight`, `rt.match.weight`, and `ms2.match.weight` must sum to 1. If any of the matching scores (m/z, RT, SS) contain `NA` values, those scores are treated as 0 in the total score calculation.
}
\examples{
\dontrun{
# Example matching scores
mz_scores <- c(0.9, 0.8, 0.7)
rt_scores <- c(0.8, 0.7, 0.9)
ss_scores <- c(0.7, 0.9, 0.8)

# Calculate the total score using the default weights
total_scores <- calculate_total_score(
  mz.match.score = mz_scores,
  RT.match.score = rt_scores,
  SS = ss_scores,
  based_on = c("ms1", "rt", "ms2")
)
print(total_scores)
}


}
