% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_zzz.R
\name{calculate_confidence_level}
\alias{calculate_confidence_level}
\title{Calculate Confidence Level for Metabolite Annotations}
\usage{
calculate_confidence_level(annotation_result)
}
\arguments{
\item{annotation_result}{A data frame containing the annotation results, including the columns `mz.error`, `RT.error`, and `SS`.}
}
\value{
A numeric vector of confidence levels (1, 2, or 3) for each annotation in the input data.
}
\description{
This function calculates the confidence level for each annotation based on the presence or absence of m/z error, retention time (RT) error, and spectral similarity (SS).
}
\details{
The function assigns a confidence level to each annotation according to the following rules:
\describe{
  \item{1}{All of `mz.error`, `RT.error`, and `SS` are available (not NA).}
  \item{2}{Any two of the three (`mz.error`, `RT.error`, or `SS`) are available.}
  \item{3}{Only one or none of `mz.error`, `RT.error`, or `SS` is available.}
}
}
\examples{
\dontrun{
# Assuming `my_annotation_result` is the annotation data frame:
confidence_levels <- calculate_confidence_level(my_annotation_result)
}

}
\seealso{
\code{\link{annotate_metabolites}}, \code{\link{plot_ms2_matching}}
}
