---
title: AudioClip Values
description: Numbers for audio values for slide reels
---

These values can be used to set the sound for slide reels, signals, audio volumes, cloak volumes, and star system travel music. Normally this will be set with a parameter called "audio".

## AudioType

Ignore the numbers, just take the name.

|                    **Name**                    | **Value** |
| :--------------------------------------------: | :-------: |
|                      None                      |     0     |
|                 Menu_RebindKey                 |     1     |
|               Menu_ResetDefaults               |     2     |
|                  Menu_UpDown                   |     3     |
|                 Menu_LeftRight                 |     4     |
|                 Menu_ChangeTab                 |     5     |
|                   Menu_Pause                   |     6     |
|                  Menu_Unpause                  |     7     |
|              Menu_SliderIncrement              |     8     |
|                 ToolScopeEquip                 |    100    |
|                ToolScopeUnequip                |    101    |
|              ToolScopeSwitchFreq               |    104    |
|                ToolScopeStatic                 |    105    |
|           ToolScopeHideAndSeekSignal           |    106    |
|              ToolScopeZoomAdjust               |    107    |
|            ToolScopeIdentifySignal             |    108    |
|              ToolItemScrollPickUp              |    200    |
|               ToolItemScrollDrop               |    201    |
|              ToolItemScrollInsert              |    202    |
|              ToolItemScrollRemove              |    203    |
|             ToolItemWarpCorePickUp             |    204    |
|              ToolItemWarpCoreDrop              |    205    |
|             ToolItemWarpCoreInsert             |    206    |
|             ToolItemWarpCoreRemove             |    207    |
|           ToolItemSharedStonePickUp            |    208    |
|            ToolItemSharedStoneDrop             |    209    |
|           ToolItemSharedStoneInsert            |    210    |
|           ToolItemSharedStoneRemove            |    211    |
|                ToolRepairing_LP                |    300    |
|               ToolRepairComplete               |    301    |
|              ToolTranslatorEquip               |    400    |
|             ToolTranslatorUnequip              |    401    |
|              ToolTranslateText_LP              |    402    |
|                ToolFlashlightOn                |    500    |
|               ToolFlashlightOff                |    501    |
|             ToolFlashlightFlicker              |    502    |
|                 ToolProbeEquip                 |    600    |
|                ToolProbeUnequip                |    601    |
|                ToolProbeLaunch                 |    602    |
|           ToolProbeLaunchUnderwater            |    603    |
|               ToolProbeTakePhoto               |    604    |
|           ToolProbeTakeReversePhoto            |    605    |
|               ToolProbeRetrieve                |    606    |
|               ToolProbeFlight_LP               |    607    |
|                ToolProbeAttach                 |    608    |
|              ToolProbeChangeMode               |    609    |
|              ToolMarshmallowEquip              |    700    |
|             ToolMarshmallowReplace             |    701    |
|             ToolMarshmallowIgnite              |    702    |
|             ToolMarshmallowBlowOut             |    703    |
|               ToolMarshmallowEat               |    704    |
|            ToolMarshmallowEatBurnt             |    705    |
|              ToolMarshmallowToss               |    706    |
|               PlayerSuitWearSuit               |    800    |
|              PlayerSuitRemoveSuit              |    801    |
|              PlayerSuitWearHelmet              |    802    |
|             PlayerSuitRemoveHelmet             |    803    |
|             PlayerSuitOxygenRefill             |    804    |
|            PlayerSuitOxygenLeak_In             |    805    |
|            PlayerSuitOxygenLeak_LP             |    806    |
|            PlayerSuitOxygenLeak_Out            |    807    |
|                PlayerSuitLockOn                |    808    |
|               PlayerSuitLockOff                |    809    |
|               PlayerSuitWarning                |    810    |
|           PlayerSuitCriticalWarning            |    811    |
|    PlayerSuitJetpackThrustTranslational_LP     |    812    |
|       PlayerSuitJetpackThrustRotational        |    813    |
|             PlayerSuitJetpackBoost             |    814    |
| PlayerSuitJetpackThrustRotationalUnderwater_LP |    816    |
|      PlayerSuitJetpackThrustUnderwater_LP      |    817    |
|             PlayerSuitRainOnHelmet             |    818    |
|      PlayerSuitNotificationTextScroll_In       |    820    |
|      PlayerSuitNotificationTextScroll_LP       |    821    |
|             PlayerSuitHelmetCrack              |    822    |
|          PlayerSuitOxygenRefill_Short          |    823    |
|            PlayerSuitPatchPuncture             |    824    |
|      PlayerSuitJetpackOxygenPropellant_LP      |    825    |
|               PlayerBreathing_LP               |    850    |
|          PlayerBreathing_LowOxygen_LP          |    851    |
|                PlayerGasp_Light                |    852    |
|               PlayerGasp_Medium                |    853    |
|                PlayerGasp_Heavy                |    854    |
|             Asphyxiate_Start_Suit              |    855    |
|            Asphyxiate_Start_NoSuit             |    856    |
|              Asphyxiate_End_Suit               |    857    |
|             Asphyxiate_End_NoSuit              |    858    |
|                 Drowning_Start                 |    859    |
|                  Drowing_End                   |    860    |
|           PlayerGasp_StopSuffocating           |    861    |
|        PlayerGasp_StopSuffocating_Suit         |    862    |
|            EnterVolumeDamageHeat_LP            |    900    |
|         EnterVolumeDamageGhostfire_LP          |    901    |
|            EnterVolumeDamageLava_LP            |    902    |
|            EnterVolumeDamageFire_LP            |    903    |
|            HazardFirstContactDamage            |    904    |
|                 ElectricShock                  |    905    |
|               Splash_GhostMatter               |    950    |
|                  Splash_Lava                   |    951    |
|                Submerge_Player                 |    952    |
|                 Submerge_Ship                  |    953    |
|               Splash_Water_Probe               |    954    |
|              Splash_Water_Player               |    955    |
|               Splash_Water_Ship                |    956    |
|              NonDiaMapActivation               |   1000    |
|                 DialogueEnter                  |   1001    |
|                DialogueAdvance                 |   1002    |
|                  DialogueExit                  |   1003    |
|             NonDiaUIAffirmativeSFX             |   1004    |
|              NonDiaUINegativeSFX               |   1005    |
|               TapeRecorder_Start               |   1006    |
|                TapeRecorder_LP                 |   1007    |
|               TapeRecorder_Stop                |   1008    |
|              PlayerTurbulence_LP               |   1050    |
|               ShipTurbulence_LP                |   1051    |
|                 ShipRattle_LP                  |   1052    |
|               ShipReentryBurn_LP               |   1053    |
|                  PLACEHOLDER                   |   1100    |
|                  LandingGrass                  |   1102    |
|                  LandingDirt                   |   1103    |
|                  LandingStone                  |   1104    |
|                  LandingMetal                  |   1105    |
|               LandingNomaiMetal                |   1106    |
|                  LandingSand                   |   1107    |
|                   LandingIce                   |   1108    |
|                  LandingWater                  |   1109    |
|                ImpactUnderwater                |   1110    |
|                 ImpactLowSpeed                 |   1111    |
|               ImpactMediumSpeed                |   1112    |
|                ImpactHighSpeed                 |   1113    |
|                MovementFootstep                |   1114    |
|              MovementRunningStep               |   1115    |
|             MovementGrassFootstep              |   1116    |
|              MovementDirtFootstep              |   1117    |
|             MovementStoneFootstep              |   1118    |
|             MovementMetalFootstep              |   1119    |
|           MovementNomaiMetalFootstep           |   1120    |
|              MovementSandFootstep              |   1121    |
|              MovementIceFootstep               |   1122    |
|          MovementShallowWaterFootstep          |   1123    |
|                  MovementJump                  |   1124    |
|           MovementWoodCreakFootstep            |   1134    |
|            MovementWoodCreakLanding            |   1135    |
|              MovementWoodFootstep              |   1136    |
|              MovementWoodLanding               |   1137    |
|              MovementSnowFootstep              |   1138    |
|              MovementSnowLanding               |   1139    |
|               MovementIceLSiding               |   1140    |
|             MovementGlassFootsteps             |   1141    |
|              MovementGlassLanding              |   1142    |
|             MovementPassingBushes              |   1143    |
|            MovementLeavesFootsteps             |   1144    |
|             MovementLeavesLanding              |   1145    |
|            MovementGravelFootsteps             |   1146    |
|             MovementGravelLanding              |   1147    |
|                 KnockOverCairn                 |   1150    |
|               DefaultPropImpact                |   1151    |
|               NomaiShuttleImpact               |   1152    |
|                ModelShipImpact                 |   1153    |
|            ShipCockpitScopeActivate            |   1200    |
|           ShipCockpitScopeDeactivate           |   1201    |
|             ShipCockpitScopeZoomIn             |   1202    |
|            ShipCockpitScopeZoomOut             |   1203    |
|           ShipCockpitScopeSwitchFreq           |   1204    |
|         ShipCockpitScopeScreenSlide_LP         |   1205    |
|         ShipCockpitScopeScreenKachunk          |   1206    |
|           ShipCockpitMasterAlarm_LP            |   1207    |
|          ShipCockpitAutopilotActivate          |   1208    |
|         ShipCockpitAutopilotDeactivate         |   1209    |
|              ShipCockpitBuckleUp               |   1210    |
|              ShipCockpitUnbuckle               |   1211    |
|          ShipCockpitConsoleReadout_In          |   1212    |
|          ShipCockpitConsoleReadout_LP          |   1213    |
|            ShipCockpitHeadlightsOn             |   1214    |
|            ShipCockpitHeadlightsOff            |   1215    |
|         ShipCockpitLandingCamActivate          |   1216    |
|        ShipCockpitLandingCamDeactivate         |   1217    |
|         ShipCockpitLandingCamStatic_LP         |   1218    |
|      ShipCockpitProbeCameraScreenRotation      |   1219    |
|            ShipCockpitProbeActivate            |   1220    |
|           ShipCockpitProbeDeactivate           |   1221    |
|             ShipCockpitProbeLaunch             |   1222    |
|        ShipCockpitProbeLaunchUnderwater        |   1223    |
|           ShipCockpitProbeTakePhoto            |   1224    |
|            ShipCockpitProbeRetrieve            |   1225    |
|        ShipCockpitLandingCamAmbient_LP         |   1226    |
|                ShipCockpitEject                |   1227    |
|               ShipCabinUseMedkit               |   1300    |
|             ShipCabinUseRefueller              |   1301    |
|           ShipCabinComputerActivate            |   1302    |
|          ShipCabinComputerAmbient_LP           |   1303    |
|                 ShipHatchOpen                  |   1304    |
|                 ShipHatchClose                 |   1305    |
|                 ShipHullGroan                  |   1309    |
|               ShipCabinAmbience                |   1310    |
|                 ShipEatenGroan                 |   1311    |
|                 ShipLogBootUp                  |   1350    |
|               ShipLogAmbience_LP               |   1351    |
|           ShipLogEnterDetectiveMode            |   1355    |
|              ShipLogEnterMapMode               |   1356    |
|               ShipLogNavigate_LP               |   1357    |
|              ShipLogSelectPlanet               |   1360    |
|             ShipLogDeselectPlanet              |   1361    |
|           ShipLogMoveBetweenPlanets            |   1362    |
|           ShipLogMoveBetweenEntries            |   1363    |
|               ShipLogRevealEntry               |   1365    |
|             ShipLogHighlightEntry              |   1366    |
|               ShipLogSelectEntry               |   1367    |
|              ShipLogDeselectEntry              |   1368    |
|              ShipLogTextReveal_LP              |   1370    |
|              ShipLogMarkLocation               |   1390    |
|             ShipLogUnmarkLocation              |   1391    |
|         ShipDamageExternalTankLeak_LP          |   1400    |
|         ShipDamageElectricSparking_LP          |   1401    |
|          ShipDamageCockpitGlassCrack           |   1402    |
|            ShipDamageShipExplosion             |   1403    |
|         ShipDamageSingleElectricSpark          |   1404    |
|             ShipDamageFuelLeak_LP              |   1405    |
|            ShipDamageOxygenLeak_LP             |   1406    |
|          ShipDamageElectricalFailure           |   1407    |
|              ShipImpact_NoDamage               |   1420    |
|             ShipImpact_LightDamage             |   1421    |
|            ShipImpact_MediumDamage             |   1422    |
|             ShipImpact_HeavyDamage             |   1423    |
|              Ship_LandingPad_Soft              |   1424    |
|              Ship_LandingPad_Hard              |   1425    |
|               ShipThrustIgnition               |   1500    |
|              ShipThrustRotational              |   1501    |
|         ShipThrustRotationalUnderwater         |   1502    |
|           ShipThrustTranslational_LP           |   1503    |
|      ShipThrustTranslationalUnderwater_LP      |   1504    |
|             ShipThrustAfterburn_LP             |   1505    |
|                NomaiHologram_LP                |   1550    |
|             NomaiHologramActivate              |   1551    |
|            NomaiHologramDeactivate             |   1552    |
|          NomaiRemoteCameraAmbient_LP           |   1553    |
|             NomaiRemoteCameraEntry             |   1554    |
|             NomaiRemoteCameraExit              |   1555    |
|              NomaiComputerAmbient              |   1600    |
|           NomaiComputerRingActivate            |   1601    |
|          NomaiComputerRingDeactivate           |   1602    |
|               NomaiOrbStartDrag                |   1603    |
|              NomaiOrbDragging_LP               |   1604    |
|               NomaiOrbRolling_LP               |   1605    |
|             NomaiOrbSlotActivated              |   1606    |
|           NomaiGravCrystalAmbient_LP           |   1609    |
|       NomaiGravCrystalFlickerAmbient_LP        |   1610    |
|          NomaiGravityCannonAmbient_LP          |   1611    |
|           NomaiGravityCannonActivate           |   1612    |
|          NomaiGravityCannonDeactivate          |   1613    |
|            NomaiTractorBeamActivate            |   1614    |
|           NomaiTractorBeamDeactivate           |   1615    |
|           NomaiTractorBeamAmbient_LP           |   1616    |
|            NomaiRecorderAmbient_LP             |   1617    |
|        NomaiEscapePodDistressSignal_LP         |   1618    |
|               NomaiTextReveal_LP               |   1619    |
|               NomaiDataStream_LP               |   1620    |
|                  NomaiPowerOn                  |   1621    |
|                 NomaiPowerOff                  |   1622    |
|                 NomaiLightsOn                  |   1623    |
|                 NomaiLightsOff                 |   1624    |
|             NomaiAirLockAirPourIn              |   1625    |
|             NomaiAirLockAirPourOut             |   1626    |
|              NomaiDoorAirLockOpen              |   1627    |
|                 NomaiDoorStart                 |   1628    |
|                 NomaiDoorStop                  |   1629    |
|               NomaiDoorSlide_LP                |   1630    |
|               NomaiDoorStartBig                |   1631    |
|                NomaiDoorStopBig                |   1632    |
|              NomaiDoorSlideBig_LP              |   1633    |
|            NomaiHeadStatueRotate_LP            |   1634    |
|             NomaiPedestalSlide_LP              |   1635    |
|              NomaiPedestalContact              |   1636    |
|              NomaiEscapePodHatch               |   1645    |
|               NomaiTimeLoopOpen                |   1646    |
|               NomaiTimeLoopClose               |   1647    |
|               NomaiVesselPowerUp               |   1648    |
|            NomaiPillarRaiseLower_LP            |   1649    |
|               NomaiPillarRotate                |   1650    |
|              NomaiAirlockSlide_LP              |   1651    |
|            NomaiAirlockWaterPourOut            |   1652    |
|            NomaiAirlockWaterPourIn             |   1653    |
|             HT_SurfaceAmbience_LP              |   1700    |
|              HT_CaveAmbientBig_LP              |   1702    |
|             HT_CaveAmbientSmall_LP             |   1703    |
|              HT_SandColumnEnd_LP               |   1705    |
|             HT_SandColumnStart_LP              |   1706    |
|           HT_SandfallSmallBottom_LP            |   1707    |
|                HT_SandRiver_LP                 |   1708    |
|           HT_InsideSandfall_Suit_LP            |   1709    |
|           HT_InsideSandfall_Ship_LP            |   1710    |
|               TH_ModelShipCrash                |   1800    |
|              TH_SatelliteSnapshot              |   1801    |
|              TH_RetrieveModelShip              |   1803    |
|          TH_ZeroGTrainingAllRepaired           |   1804    |
|            TH_CanyonAmbienceDay_LP             |   1807    |
|           TH_CanyonAmbienceNight_LP            |   1808    |
|          TH_HiAltitudeAmbienceDay_LP           |   1809    |
|         TH_HiAltitudeAmbienceNight_LP          |   1810    |
|             TH_ZeroGCaveAmbient_LP             |   1811    |
|            TH_UnderwaterCurrent_LP             |   1812    |
|            TH_UnderwaterAmbience_LP            |   1813    |
|              TH_MuseumAmbience_LP              |   1814    |
|              TH_BridgeCreaking_LP              |   1819    |
|                 TH_Campfire_LP                 |   1820    |
|               TH_FlagFlapping_LP               |   1821    |
|                  TH_GeyserEnd                  |   1822    |
|                  TH_Geyser_LP                  |   1823    |
|                 TH_GeyserStart                 |   1824    |
|                 TH_Insects_LP                  |   1825    |
|                TH_LiftActivate                 |   1826    |
|                 TH_LiftArrives                 |   1827    |
|                   TH_Lift_LP                   |   1828    |
|              TH_ProjectorActivate              |   1829    |
|               TH_ProjectorRun_LP               |   1830    |
|                TH_ProjectorStop                |   1831    |
|              TH_RiverWaterFlow_LP              |   1832    |
|                TH_Waterfall_LP                 |   1833    |
|                TH_WaterWheel_LP                |   1834    |
|         TH_ModelRocketThrustRotational         |   1835    |
|      TH_ModelRocketThrustTranslational_LP      |   1836    |
|               TH_Campfire_Ignite               |   1837    |
|                TH_RockingChair                 |   1838    |
|                 TH_BanjoTuning                 |   1839    |
|                TH_PickaxeImpact                |   1840    |
|                 TH_WoodCarving                 |   1841    |
|               TH_RadioSignal_LP                |   1842    |
|              BH_BreakawayFragment              |   1900    |
|           BH_VolcanicMoonSurface_LP            |   1901    |
|              BH_BreakawayPlatform              |   1902    |
|                BH_MeteorImpact                 |   1903    |
|              BH_BlackHoleEmission              |   1904    |
|             BH_SurfaceAmbience_LP              |   1905    |
|            BH_SubsurfaceAmbience_LP            |   1906    |
|             WHS_StationActivation              |   1907    |
|               BH_ForgeMoving_LP                |   1908    |
|                BH_MeteorLaunch                 |   1909    |
|               GD_OceanSurface_LP               |   2000    |
|            GD_UnderwaterAmbient_LP             |   2002    |
|               GD_CoreAmbient_LP                |   2004    |
|             GD_ElectricBarrier_LP              |   2005    |
|                 GD_Tornado_LP                  |   2006    |
|                  GD_Lightning                  |   2007    |
|               GD_RainAmbient_LP                |   2008    |
|                GD_IslandSplash                 |   2009    |
|                GD_IslandFalling                |   2010    |
|            GD_IslandLiftedByTornado            |   2011    |
|                GD_WavesBeach_LP                |   2012    |
|                GD_WavesRock_LP                 |   2013    |
|               GD_CaveAmbience_LP               |   2014    |
|            GD_UnderwaterCurrent_LP             |   2015    |
|             DBAnglerfishLurking_LP             |   2100    |
|             DBAnglerfishChasing_LP             |   2101    |
|         DBAnglerfishDetectDisturbance          |   2102    |
|            DBAnglerfishDetectTarget            |   2103    |
|                DBAnglerfishBite                |   2104    |
|               DBAnglerfishChomp                |   2105    |
|            DBAnglerfishOpeningMouth            |   2106    |
|                 DB_Ambience_LP                 |   2107    |
|                 DB_VineImpact                  |   2108    |
|                CometAmbience_LP                |   2200    |
|               CometIceMelting_LP               |   2201    |
|              SolanumStaffContact               |   2210    |
|                  SolanumStomp                  |   2211    |
|              SolanumCairnAssembly              |   2212    |
|               SolanumCairnSettle               |   2213    |
|              SolanumSymbolReveal               |   2214    |
|              SolanumEnterWriting               |   2215    |
|               SolanumExitWriting               |   2216    |
|                SolanumEnterIcon                |   2217    |
|                SolanumExitIcon                 |   2218    |
|             SolanumEnterRaiseCairn             |   2219    |
|             SolanumExitRaiseCairn              |   2220    |
|                 EyeAmbience_LP                 |   2250    |
|                  EyeLightning                  |   2251    |
|                  EyeVortex_LP                  |   2252    |
|               VesselAmbience_LP                |   2253    |
|                 EyeVortexEntry                 |   2254    |
|                 EyeVortexExit                  |   2255    |
|                 EyeGalaxyZoom                  |   2260    |
|               EyeGalaxyBlowAway                |   2261    |
|                EyeBigGalaxyBurn                |   2262    |
|                EyeShuttleFlight                |   2270    |
|              EyeShuttleIntoLight               |   2271    |
|              EyeSmokeSpherePulse               |   2280    |
|             EyeSmokeSphereCollapse             |   2281    |
|               EyeCosmicInflation               |   2282    |
|                   EyeBigBang                   |   2283    |
|               EyeBigBangWall_LP                |   2284    |
|              EyeSmokeSphereEntry               |   2285    |
|               EyeSphereInflation               |   2286    |
|                 TravelerEsker                  |   2300    |
|                 TravelerChert                  |   2301    |
|                TravelerRiebeck                 |   2302    |
|                 TravelerGabbro                 |   2303    |
|                TravelerFeldspar                |   2304    |
|                 TravelerNomai                  |   2305    |
|                TravelerEnd_All                 |   2306    |
|              TravelerEnd_NoPiano               |   2307    |
|               SingularityCreate                |   2400    |
|              SingularityCollapse               |   2401    |
|          SingularityOnPlayerEnterExit          |   2402    |
|            SingularityOnObjectEnter            |   2403    |
|            SingularityOnObjectExit             |   2404    |
|            Singularity_BlackHole_LP            |   2405    |
|            Singularity_WhiteHole_LP            |   2406    |
|            VesselSingularityCreate             |   2407    |
|           VesselSingularityCollapse            |   2408    |
|                Sun_Ambience_LP                 |   2412    |
|                 Sun_Explosion                  |   2413    |
|              Sun_SupernovaWall_LP              |   2414    |
|                  Sun_Collapse                  |   2415    |
|               QuantumAmbience_LP               |   2424    |
|              WhiteHoleAmbience_LP              |   2425    |
|              BlackHoleAmbience_LP              |   2426    |
|            TimelineEndEffect_Shadow            |   2427    |
|            TimelineEndEffect_Cracks            |   2428    |
|           TimelineEndEffect_Shatter            |   2429    |
|                 FigBackerVideo                 |   2440    |
|                   CometPurr                    |   2441    |
|                 Death_Instant                  |   2450    |
|                 Death_Crushed                  |   2451    |
|                  Death_Energy                  |   2452    |
|                Death_Digestion                 |   2453    |
|                 Death_TimeLoop                 |   2454    |
|                   Death_Self                   |   2455    |
|                 Death_BigBang                  |   2456    |
|                   Death_Lava                   |   2457    |
|            Death_CrushedByElevator             |   2458    |
|               MemoryUplink_Start               |   2460    |
|                MemoryUplink_End                |   2461    |
|                MemoryUplink_LP                 |   2462    |
|            MemoryUplink_Overlay_LP             |   2463    |
|                 Flashback_End                  |   2465    |
|               Flashback_Base_LP                |   2466    |
|             Flashback_Overlay_1_LP             |   2467    |
|             Flashback_Overlay_2_LP             |   2468    |
|              NomaiRuinsBaseTrack               |   2500    |
|            NomaiRuinsBaseScaryTrack            |   2501    |
|            NomaiRuinsOverlayTracks             |   2502    |
|                    HT_City                     |   2503    |
|                 TH_Observatory                 |   2504    |
|                   TH_Village                   |   2505    |
|                 BH_Observatory                 |   2506    |
|            GD_UnderwaterExploration            |   2507    |
|                   QM_Ambient                   |   2508    |
|                   DB_Ambient                   |   2509    |
|             TimeLoopDevice_Ambient             |   2510    |
|                   EndOfTime                    |   2511    |
|               EndOfTime_DBFinal                |   2512    |
|                EndOfTime_Final                 |   2513    |
|                  Travel_Theme                  |   2514    |
|                   SunStation                   |   2515    |
|                 SadNomaiTheme                  |   2516    |
|               DB_VesselDiscovery               |   2517    |
|              EYE_ForestOfGalaxies              |   2518    |
|               EndOfTime_Final_LP               |   2519    |
|            EYE_QuantumFoamApproach             |   2520    |
|                 EYE_EndOfGame                  |   2521    |
|                 MainMenuTheme                  |   2522    |
|                  FinalCredits                  |   2523    |
|                  PostCredits                   |   2524    |
|                   KazooTheme                   |   2525    |
|               Raft_Impact_Light                |   2550    |
|               Raft_Impact_Medium               |   2551    |
|               Raft_Impact_Heavy                |   2552    |
|                   Raft_Push                    |   2553    |
|                Raft_Reel_Start                 |   2554    |
|                 Raft_Reel_Loop                 |   2555    |
|                 Raft_Reel_End                  |   2556    |
|                  Raft_Socket                   |   2557    |
|                  Raft_Release                  |   2558    |
|                Raft_RunAground                 |   2559    |
|                Raft_Move_Start                 |   2560    |
|                 Raft_Move_Loop                 |   2561    |
|                 Raft_Move_End                  |   2562    |
|               Raft_Impact_Player               |   2563    |
|                 Raft_DW_Turbo                  |   2564    |
|            Door_SensorSliding_Loop             |   2570    |
|                   Door_Loop                    |   2571    |
|               Door_Loop_Creaking               |   2572    |
|                 Door_OpenStart                 |   2573    |
|                 Door_OpenStop                  |   2574    |
|                Door_CloseStart                 |   2575    |
|                 Door_CloseStop                 |   2576    |
|              Door_Metal_OpenStart              |   2577    |
|              Door_Metal_OpenStop               |   2578    |
|             Door_Metal_CloseStart              |   2579    |
|              Door_Metal_CloseStop              |   2580    |
|              Door_Small_OpenStart              |   2581    |
|              Door_Small_OpenStop               |   2582    |
|             Door_Small_CloseStart              |   2583    |
|              Door_Small_CloseStop              |   2584    |
|              SecretPassage_Start               |   2590    |
|               SecretPassage_Loop               |   2591    |
|               SecretPassage_Stop               |   2592    |
|                  Airlock_Open                  |   2593    |
|                  Airlock_Loop                  |   2594    |
|                 Airlock_Close                  |   2595    |
|               Airlock_Pressurize               |   2596    |
|              Airlock_Depressurize              |   2597    |
|                 AirRushingOut                  |   2598    |
|                SlideReel_Pickup                |   2600    |
|                 SlideReel_Drop                 |   2601    |
|                SlideReel_Insert                |   2602    |
|                SlideReel_Remove                |   2603    |
|                 Lantern_Pickup                 |   2604    |
|                  Lantern_Drop                  |   2605    |
|                 Lantern_Insert                 |   2606    |
|                 Lantern_Remove                 |   2607    |
|                Lantern_ShortOut                |   2608    |
|                Artifact_Pickup                 |   2609    |
|                 Artifact_Drop                  |   2610    |
|                 Artifact_Light                 |   2611    |
|              Artifact_Extinguish               |   2612    |
|                Artifact_Conceal                |   2613    |
|               Artifact_Unconceal               |   2614    |
|                 Artifact_Focus                 |   2615    |
|                Artifact_Unfocus                |   2616    |
|            Artifact_Crackling_Loop             |   2617    |
|                Artifact_Insert                 |   2618    |
|                Artifact_Remove                 |   2619    |
|            VisionTorch_ProjectionOn            |   2620    |
|           VisionTorch_ProjectionOff            |   2621    |
|            VisionTorch_EnterVision             |   2622    |
|             VisionTorch_ExitVision             |   2623    |
|             VisionTorch_NextSlide              |   2624    |
|           VisionTorch_Scanning_Loop            |   2625    |
|           VisionTorch_Crackling_Loop           |   2626    |
|                VisionTorch_Give                |   2627    |
|                VisionTorch_Take                |   2628    |
|                DamBreak_RW_Base                |   2650    |
|                DamBreak_DW_Base                |   2651    |
|               DamBreak_RW_Water                |   2652    |
|                    DamCrack                    |   2653    |
|                 DamCrack_Loop                  |   2654    |
|                WaterSpray_Small                |   2660    |
|                WaterSpray_Large                |   2661    |
|                 Splash_Medium                  |   2662    |
|                  Splash_Large                  |   2663    |
|                   WoodDebris                   |   2670    |
|                WoodImpact_Small                |   2671    |
|                WoodImpact_Large                |   2672    |
|              HouseCollapse_Zone3               |   2673    |
|               GeneralDestruction               |   2674    |
|                HouseDestruction                |   2675    |
|                StiltDestruction                |   2676    |
|                 Tower_RW_Tilt                  |   2680    |
|                Tower_RW_Fall_1                 |   2681    |
|                Tower_RW_Fall_2                 |   2682    |
|                 Tower_DW_Tilt                  |   2683    |
|                Tower_DW_Fall_1                 |   2684    |
|                Tower_DW_Fall_2                 |   2685    |
|                Tower_RW_Splash                 |   2686    |
|               SolarSail_RW_Start               |   2690    |
|                SolarSail_RW_End                |   2691    |
|               SolarSail_RW_Loop                |   2692    |
|               SolarSail_DW_Start               |   2693    |
|                SolarSail_DW_End                |   2694    |
|               SolarSail_DW_Loop                |   2695    |
|               StationFlicker_RW                |   2696    |
|               StationFlicker_DW                |   2697    |
|               StationShudder_RW                |   2698    |
|               StationShudder_DW                |   2699    |
|                 River_DW_Base                  |   2700    |
|               FloodWave_DW_Loop                |   2701    |
|                 River_DW_Lake                  |   2703    |
|                Candle_Light_Big                |   2719    |
|               Candle_Light_Small               |   2720    |
|               Candle_Extinguish                |   2721    |
|            DreamFire_Crackling_Loop            |   2722    |
|              DreamFire_Extinguish              |   2723    |
|              DreamFire_Explosion               |   2724    |
|            LodgeFire_Crackling_Loop            |   2725    |
|              ProjectorTotem_Pulse              |   2729    |
|              ProjectorTotem_Light              |   2730    |
|           ProjectorTotem_Extinguish            |   2731    |
|              ProjectorTotem_Blow               |   2732    |
|               GrappleTotem_Zoom                |   2733    |
|             GrappleTotem_RetroZoom             |   2734    |
|                Simulation_Enter                |   2739    |
|                Simulation_Exit                 |   2740    |
|               IllusoryWall_Enter               |   2741    |
|               IllusoryWall_Exit                |   2742    |
|               LoadingZone_Enter                |   2743    |
|                LoadingZone_Exit                |   2744    |
|             LoadingZone_GlitchOut              |   2745    |
|                LoadingZone_Loop                |   2746    |
|                  Glitch_Loop                   |   2747    |
|              Sarcophagus_OpenFail              |   2760    |
|                Sarcophagus_Open                |   2761    |
|         Sarcophagus_SomethingIsComing          |   2762    |
|           Sarcophagus_TunnelAmbience           |   2763    |
|          Sarcophagus_LightsOnAmbience          |   2764    |
|                Ambience_DW_Base                |   2775    |
|             Ambience_DW_LightsOut              |   2776    |
|               Ambience_DW_Hotel                |   2777    |
|               Ambience_DW_Nature               |   2778    |
|               Ambience_DW_Forest               |   2781    |
|             Ambience_DW_Simulation             |   2782    |
|            Ambience_DW_Underground             |   2784    |
|              Ambience_DW_FireRoom              |   2787    |
|            PointSounds_DW_TreeCreak            |   2790    |
|           PointSounds_DW_Creature_1            |   2791    |
|           PointSounds_DW_Creature_2            |   2792    |
|             PointSounds_DW_Hotel_2             |   2795    |
|                 AlarmChime_RW                  |   2798    |
|                 AlarmChime_DW                  |   2799    |
|                 LightSensor_On                 |   2800    |
|                LightSensor_Off                 |   2801    |
|                LightSensor_Loop                |   2802    |
|                 Projector_Prev                 |   2803    |
|                 Projector_Next                 |   2804    |
|                  Cloak_Entry                   |   2805    |
|                   Cloak_Exit                   |   2806    |
|                GearRotate_Light                |   2807    |
|                GearRotate_Heavy                |   2808    |
|                GearRotate_Fail                 |   2809    |
|              CodeTotem_Horizontal              |   2810    |
|               CodeTotem_Vertical               |   2811    |
|               CageElevator_Start               |   2817    |
|            CageElevator_Loop_Winch             |   2818    |
|                CageElevator_End                |   2819    |
|            CageElevator_Loop_Rattle            |   2820    |
|                Ambience_RW_Lab                 |   2873    |
|               Ambience_RW_Tunnel               |   2874    |
|              Ambience_RW_FireRoom              |   2875    |
|                Ambience_RW_Base                |   2876    |
|                Ambience_RW_Cave                |   2877    |
|               Ambience_RW_Indoor               |   2878    |
|                 River_RW_Base                  |   2879    |
|                River_Underwater                |   2880    |
|                River_Reservoir                 |   2881    |
|                  River_Rapids                  |   2882    |
|            River_Underwater_Rapids             |   2883    |
|               FloodWave_RW_Loop                |   2884    |
|                 River_RW_Small                 |   2885    |
|                River_RW_Stream                 |   2886    |
|             PostCredit_RuinReveal              |   2887    |
|            PostCredit_LanternLight             |   2889    |
|                RaftTravel_River                |   2890    |
|              RaftTravel_Reservoir              |   2891    |
|          GhostSequence_ReducedFrights          |   2895    |
|             GhostSequence_Suspense             |   2896    |
|              GhostSequence_Dread               |   2897    |
|               GhostSequence_Fear               |   2898    |
|            GhostSequence_Fear_Slam             |   2899    |
|                EndOfTime_Dream                 |   2900    |
|                StationDiscovery                |   2901    |
|                 DreamFireRoom                  |   2902    |
|               EyeTemple_Stinger                |   2903    |
|               EyeTemple_Basement               |   2904    |
|                SlideBurningRoom                |   2905    |
|               SubmergedStructure               |   2906    |
|                 SecretLibrary                  |   2907    |
|            DreamRuinsOverlayTracks             |   2908    |
|              DreamRuinsBaseTrack               |   2909    |
|                TravelerPrisoner                |   2910    |
|            TravelerEnd_All_Prisoner            |   2911    |
|          TravelerEnd_NoPiano_Prisoner          |   2912    |
|               Prisoner_Elevator                |   2913    |
|                Prisoner_Reveal                 |   2914    |
|               Prisoner_Catharsis               |   2915    |
|                 SecretPortrait                 |   2916    |
|                  SecretKorok                   |   2917    |
|              PartyHouse_Traveler               |   2920    |
|               PartyHouse_Vocals                |   2921    |
|                PartyHouse_Drone                |   2922    |
|                PartyHouse_Bass                 |   2923    |
|             Reel_Secret_Backdrop_A             |   2924    |
|             Reel_Secret_Backdrop_B             |   2925    |
|          Reel_Secret_Beat_Peephole_A           |   2926    |
|          Reel_Secret_Beat_Peephole_B           |   2927    |
|            Reel_Secret_Beat_Tower_A            |   2928    |
|            Reel_Secret_Beat_Tower_B            |   2929    |
|            Reel_Secret_Beat_Lantern            |   2930    |
|             Reel_Lab_Backdrop_Fail             |   2933    |
|           Reel_Lab_Backdrop_Success            |   2934    |
|           Reel_Lab_Backdrop_Testing            |   2935    |
|              Reel_Backdrop_Burnt               |   2938    |
|               Reel_1_Backdrop_A                |   2940    |
|                 Reel_1_Beat_A                  |   2945    |
|                 Reel_1_Beat_B                  |   2946    |
|                 Reel_1_Beat_C                  |   2947    |
|               Reel_2_Backdrop_A                |   2950    |
|               Reel_2_Backdrop_B                |   2951    |
|                 Reel_2_Beat_A                  |   2955    |
|                 Reel_2_Beat_B                  |   2956    |
|                 Reel_2_Beat_C                  |   2957    |
|                 Reel_2_Beat_D                  |   2958    |
|               Reel_3_Backdrop_A                |   2960    |
|               Reel_3_Backdrop_B                |   2961    |
|               Reel_3_Backdrop_C                |   2962    |
|                 Reel_3_Beat_A                  |   2965    |
|                 Reel_3_Beat_B                  |   2966    |
|                 Reel_3_Beat_C                  |   2967    |
|                 Reel_3_Beat_D                  |   2968    |
|               Reel_4_Backdrop_A                |   2970    |
|                 Reel_4_Beat_A                  |   2975    |
|                 Reel_4_Beat_B                  |   2976    |
|                 Reel_4_Beat_C                  |   2977    |
|                 Reel_4_Beat_D                  |   2978    |
|                  Reel_5_Long                   |   2980    |
|                  Reel_5_Short                  |   2981    |
|                 Reel_Farewell                  |   2985    |
|          Reel_Rule_Beat_DarkDiscovery          |   2986    |
|          Reel_Rule_Backdrop_Discovery          |   2987    |
|            Reel_Rule_Beat_Discovery            |   2988    |
|            Reel_Rule_Backdrop_Dream            |   2989    |
|           Reel_Rule_Backdrop_Normal            |   2990    |
|           Reel_Rule_Backdrop_Glitch            |   2991    |
|           Reel_LibraryPath_Backdrop            |   2992    |
|               Reel_Rule2a_Beat_A               |   2993    |
|               Reel_Seal_Backdrop               |   2994    |
|            Reel_Burning_Backdrop_A             |   2995    |
|            Reel_Burning_Backdrop_B             |   2996    |
|              Reel_Burning_Beat_A               |   2997    |
|              Reel_Burning_Beat_B               |   2998    |
|              Reel_Burning_Beat_C               |   2999    |
|                Ghost_DeathGroup                |   3000    |
|               Ghost_DeathSingle                |   3001    |
|                Ghost_Grab_Swish                |   3002    |
|               Ghost_Grab_Contact               |   3003    |
|              Ghost_BlowOut_Charge              |   3004    |
|            Ghost_BlowOut_Extinguish            |   3005    |
|                 Ghost_NeckSnap                 |   3006    |
|             Ghost_Identify_Curious             |   3010    |
|            Ghost_Identify_Irritated            |   3011    |
|              Ghost_Identify_Fail               |   3012    |
|                  Ghost_Chase                   |   3013    |
|                  Ghost_Stalk                   |   3014    |
|                   Ghost_Hunt                   |   3015    |
|                 Ghost_HuntFail                 |   3016    |
|               Ghost_Grab_Scream                |   3017    |
|                Ghost_Stalk_Fast                |   3018    |
|                Ghost_Grab_Shout                |   3019    |
|           Ghost_SomeoneIsInHereHowl            |   3020    |
|            Ghost_IntruderConfirmed             |   3021    |
|        Ghost_IntruderConfirmedResponse         |   3022    |
|               Ghost_CallForHelp                |   3023    |
|           Ghost_CallForHelpResponse            |   3024    |
|                  Ghost_Laugh                   |   3025    |
|              Ghost_Footstep_Wood               |   3030    |
|          Ghost_Footstep_Wood_Running           |   3031    |
|             Ghost_Footstep_Forest              |   3032    |
|         Ghost_Footstep_Forest_Running          |   3033    |
|             Ghost_Footstep_Gravel              |   3034    |
|           Ghost_Footstep_Wood_Stompy           |   3035    |
|         Prisoner_ReactToVision_Vocals          |   3050    |
|        Prisoner_RevealToStand_Vocals_1         |   3051    |
|        Prisoner_RevealToStand_Vocals_2         |   3052    |
|            Prisoner_PickUpArtifact             |   3053    |
|              Prisoner_PickUpTorch              |   3054    |
|              Prisoner_ClothFoley               |   3055    |

## AudioClip values

This is a list of AudioClips that will also work, there's a lot of overlap with the AudioType list. Many old addons with signals use values from this list.

- Hotel Oneshot - Heavy Thud 4
- Tool_Put_Away_01
- OW Quantum Lightning 091118 AP 07
- OW_GD_ElectricBarrier_Idle_Loop
- Nomai_Stone_Door_End_V2_11
- General Destruction 1
- Dream Rule 02 backdrop loop 072321_2 AP
- amb_observatory
- Dream World Water Ambience - Creek 3
- Pickup_Rock_01
- gasp_traumatic4_lessmale
- Ship_Impact_Light_Damage_V3_06
- BlackHole_02
- OW_GD_WavesAgainstRock
- OW_TH_AmbienceInCanyons
- OW_PR_FootstepsBushRustle_03
- OW_PR_ActivateProbeMode
- Ghost Walk Footstep Wood_v2 6
- rockingchair4
- Water Spray Impact 4
- OW Secret Library 040821_2 AP
- Real World Dam Break Alex Composite 2
- Ghost Run Footstep Wood_v2 4
- UI_Enter_Dialog_V6-002_highpass_2
- Spark_10
- Mournful Prisoner 3
- OW_PR_FootstepsLeaves_06
- FootstepsWoodCreak_02
- OW Dreamworld Ruins 072021 AP 02c
- OW_PR_HitWallUnderwater1
- OW_TH_RiverWaterFlow_loop
- OW ReelBeat 01c 021021 AP
- FootstepsWoodCreak_07
- Ignite_Marshmallow_03
- Marshmallow_Replace_02
- Ship_FuelLeak
- Raft Heavy Impact 5
- elevatorloop
- Real World Alarm Bell Oneshot 3
- BigBang_EndFlash
- OW_FinalEndTimes_DB_loop
- fogsphere_pulse4
- Ringworld Ambience 3
- Destruction Impact 4
- Artifact Unconceal
- OW_NM_DoorStart_06
- OW_PR_SignalscopeZoomOut
- Nomai_Stone_Door_End_Big_V2_03
- Player Gravel Footstep 3
- General Destruction 5
- OW Dream Fire Room 121820_4 AP LP
- OW_PR_DeactivateProbeMode
- OW_PR_LandInWater4
- OW_PR_FootstepsJumpNomai_04
- OW_PR_FootstepsJumpMetal_03
- WarpCore_Remove_V3_01
- Probe_SnapShot_03
- Ghost Idle Search 4
- Solanum_Foley_IconExit
- Dream Fire Room Ambience Test 1
- Lantern Extinguish 4
- OW_PR_OxygenLeakingFromSuit_loop_louder
- Wood Door Open Stop
- OW_PR_FootstepsJumpGrass_01
- OW_SP_ThrustAfterburn
- OW_PR_FootstepsGrass_01
- Real World Alarm Bell Oneshot 4
- OW_PR_FootstepsNomai_04
- Hotel Oneshot - Heavy Thud 2
- Light Sensor Fade In 4
- AnglerFish_OpenMouth_v2_01
- Footstep_Run4
- Ghost Walk Footstep Forest 6
- OW_PR_FootstepsGrass_06
- OW_GD_AmbienceRain
- RotationalThruster04
- OW New Raft Music 082321_4 AP theme
- Spark_01
- OW Muted End Times 040821 AP
- Nomai_WhiteHoleStationActivation
- Tool_Take_Out_02
- OW_PR_FootstepsJumpDirt_05
- mallowpuff2
- Dreamworld Tower Fall Part 2
- Jump_Into_Fogsphere_04
- FootstepsWoodCreak_05
- OW_SP_MetalCreak_14
- OW_NM_DoorStart_03
- drowning_firsthalf2
- Forest Oneshot - Tree Creak 4
- shiplog_misc1
- FootstepsWoodCreak_04
- Real World Dam Crack
- OW_NM_DoorStart_09
- OW_SP_LandingPadHard4
- OW_PR_FootstepsSand_06
- BH_Ambience_Surface
- Ghost Grunt 3
- glass_crack_02
- House Destruction 3
- OW_QuantumMoon
- Orb_Roll_Energy_Loop_v2_01
- OW Eye Of The Universe 082018_2 AP
- Footstep3
- OW_NM_DoorStart_Big_01
- OW Dreamworld Ruins Story Beats 071621 AP 1d
- Dream World Tidal Wave Loop
- Nomai_Stone_Door_End_Big_V2_15
- OW_SP_ActivateComputer 1
- OW_PR_FootstepsIce_07
- Raft Light Impact V2 3
- UI_Pause_v2_08
- signalscope_static
- OW_SP_LandingCamActivated 1
- Footstep4
- OW_PR_FootstepsSand_03
- Prisoner Pick Up Vision Torch
- OW_SP_MetalCreak_16
- OW_SP_Touchdown_04
- Platform_Break_V2_03
- OW Nomai Time Loop Device 081818 AP
- RockPile_Fall_02
- Ship_Impact_No_Damage_V3_02
- Destruction Impact 7
- Ghost Grab Player 2
- Forest Oneshot - Tree Creak 5
- OW_PR_FootstepsMetal_01
- OW NM Flashback 082818_3 AP base
- Projector Totem Light 2
- Slot_Linking_Stone_Loop_02
- breathing_suit3
- OW_PR_FootstepsWood_07
- OW_SP_HeadlightsOff_v2
- Nomai_Stone_Door_End_V2_06
- Fix_Puncture_03
- OW Dream Rule LP 032421 AP glitch
- Real World Tidal Wave Loop Louder
- OW Dreamworld Ruins 072021 AP 02loop
- gasp_normal11_lessmale
- OW ReelBeat 01a 021021 AP
- OW_TH_ModelRocketThrustRotational_01
- OW_PR_FootstepsBushRustle_05
- OW NomaiRuinsRegular 081918 AP motif3c v2
- OW Final End Times 022519_2 AP LOOP1
- OW_PR_FootstepsSand_01
- Anglerfish_Awake4
- OW_PR_FootstepsJumpIce_04
- Fix_Puncture_01
- Raft Light Impact V2 1
- Warp_Loop_01_v2
- Ghost Start Hunt Grunt 1
- Destruction Debris 4
- Solanum_IconAppear_V3
- OW_SP_ActivateComputer_OneShot
- Destruction Impact 8
- OW_SP_ShipGroan1_v2
- OW ReelBackdrop 02a 021021 AP
- OW_NM_ComputerRing1
- OW_PR_FootstepsJumpGlass_04
- Forest Oneshot - Tree Creak 6
- OW_GD_HeatLightning_01
- Raft Heavy Impacts V2 3
- Solanum_Foley_RockFormStart
- Raft Light Impact V2 5
- Ghost Grunt 4
- OW_PR_FootstepsJumpDirt_06
- OW_PR_FootstepsJumpGrass_03
- OW_TravelerTheme_whistling
- Raft Heavy Impact 2
- Nature Oneshot - Distant Deep Creature 1
- OW_SP_CloseHatch_v2
- linkingstone_in
- OW_PR_FootstepsSnow_03
- OW_NM_OrbDeSelect_Energy_02
- Impact_Light_02
- Nomai_Stone_Door_End_V2_10
- Fix_Puncture_07
- OW_NM_HoleEnterExit
- OW NM Nomai Ruins 081718 AP
- OW_PR_OxygenRefill
- GhostMatter_Splash_v4_05
- glass_crack_01
- Ignite_Marshmallow_02
- Ship_Impact_Medium_Damage_V3_03
- Forest Oneshot - Animal 4
- OW_PR_FootstepsIce_02
- OW_GD_RainOnHelmet
- Spaceship_RattleLoop
- BigBang_WhooshLeadToExplo
- OW_TH_Campfire_loop_01
- bigbang_cosmicinflation_v2
- Hotel Oneshot - Heavy Creak 4
- OW_PR_FootstepsJumpGrass_02
- Tronworld Ambience 1
- AnglerFish_Target_v2_07
- Eye_of_Universe_Ambience_v2_01
- OW_PR_FootstepsJumpLeaves_04
- OW_PR_FootstepsJumpSnow_03
- OW_PR_FootstepsJumpGlass_01
- OW Traveler Theme 091118 AP FINAL TIME NO PIANO EDIT
- OW ReelBeat 02f 082521 AP
- Metal Door Close Stop
- medkit
- OW_NM_BlackHole_Lp
- Ghost Blow Out Lantern
- OW_PR_MarshmallowEatBurnt_shorter
- Solanum_Foley_IconEnter
- OW_PR_SignalscopeSwitchFrequencies
- Prisoner Pick Up Artifact
- OW_PR_BanjoStrum_3b
- Water Spray Impact 5
- UI_Advance_Dialog_V6-002_highpass
- Destruction Debris 8
- OW_PR_FootstepsDirt_06
- Vision Torch - Step In
- OW_NM_DoorStart_Big_04
- OW_PR_FootstepsBushRustle_06
- Hotel Oneshot - Creak 5
- OW_PR_FootstepsJumpLeaves_01
- OW_SP_ShipGroan4_v2
- Jump_Into_Fogsphere_03
- Dreamworld Forest Ambience 2
- OW_PR_FootstepsJumpRock_02
- CrushedByElevator
- Player Gravel Footstep 1
- House Destruction 4
- Ghost Begin Stalk Grunt 1
- flashlightOff
- OW ReelBeat 04b_2 040921 AP
- OW_PR_FootstepsRock_02
- AshTwinCore_Open_01
- OW_SP_HeadlightsOn_v2
- Tower Fall Part 2
- OW_NM_DoorStart_Big_02
- Meteor_Impact_01_b
- OW_SP_LandingCamStatic
- OW_PR_FootstepsWood_01
- gasp_light5
- OW_PR_FootstepsGrass_03
- Spark_03
- Loading Tunnel - Loop
- FootstepsJumpWoodCreak_02
- OW_Main_Menu
- Lantern Put Down
- OW Secret Library Whispers LP 040821 AP REF MIX
- OW_DB_Ambience
- Vision Torch Light Rays - On
- Hotel Oneshot - Creak 1
- Dreamworld Nature Ambience 4
- OW_PR_ThrustRotationalUnderwater_04
- OW_PR_FootstepsJumpGrass_06
- Nomai_Stone_Door_End_Big_V2_09
- Ship_Impact_No_Damage_V3_01
- Raft Movement Stop 3
- Destruction Impact 9
- Recorder_Start_Button
- AnglerFish_Target_v2_14
- Ghost Begin Chase Grunt 2
- Hotel Oneshot - Creak 6
- Fragment_Break
- Tronworld Exit 2
- Ghost Walk Footstep Forest 2
- Incinerate_v3_01
- Light Sensor Fade Out 3
- OW_TravelerTheme_flute
- OW_PR_FootstepsLeaves_02
- OW_PR_FootstepsLeaves_01
- Fix_Puncture_05
- Ghost Walk Footstep Wood_v2 3
- OW_PR_FootstepsJumpSand_01
- Sarcophagus Strain 2
- OW_PR_HitWallUnderwater4
- OW_PR_FootstepsRock_03
- Loading Tunnel - Unload
- OW_PR_FootstepsJumpNomai_03
- OW_PR_FootstepsDirt_07
- OW_PR_FootstepsSnow_04
- Wood Door Close Stop
- OW_PR_FootstepsJumpIce_02
- OW ReelBeat 04a 031521 AP
- Raft Light Impact V2 2
- Meteor_Impact_02_b
- JellyFish_Shock_02
- Metal Door Open Start
- OW_GD_UnderwaterCurrent
- OW_GD_HeatLightning_06
- nomai_textbranchout_noenergy2
- asphyxiation_nosuit_secondhalf_version3
- Artifact Focus
- Ice_Cave_Amb_loop_v3_01
- Forest Oneshot - Tree Creak 3
- OW NomaiRuinsRegular 081918 AP motif4c
- Dreamworld Lights Out Ambience 4
- Projector Next Slide 2
- BeaconIdea4
- Destruction Impact 1
- OW_PR_FootstepsNomai_06
- OW_NM_FlickeryGravityCrystalAmbience
- OW Demonic Vocal Sting 082321 AP
- OW Quantum Lightning 091118 AP 08
- OW_NM_SadTheme_older
- Nature Oneshot - Distant Creature 2 - less reverb
- FootstepsJumpWoodCreak_03
- OW_PR_FootstepsJumpSand_02
- Player Gravel Footstep 8
- OW_PR_FootstepsSnow_06
- gasp_traumatic3_lessmale
- Real World Dam Break Water Oneshot
- Repair_Loop
- OW_TH_FlagFlapping_loop.\_01
- Ship_Impact_Light_Damage_V3_02
- Raft Socket
- Jump_Into_TinyGalaxy_v2_01
- OW NomaiRuinsRegular 081918 AP motif7c
- gasp_normal13_lessmale
- Sandfall_Inside_Loop_01
- Solanum_RocksForm
- Fix_Puncture_06
- OW Dreamworld Ruins Story Beats 071621 AP 1h
- Sarcophagus Open 2
- fogsphere_pulse2
- Elevator Rattle Loop 3
- IllusoryWall_Alex
- OW_GD_HeatLightning_04
- Nomai_Stone_Door_End_Big_V2_14
- OW_PR_FootstepsJumpMetal_01
- Vine_Crash_V3_03_LowPassDelay
- OW_PR_BanjoStrum_2b
- OW_PR_FootstepsGlass_05
- OW_PR_FootstepsLeaves_07
- OW_NM_DoorStart_01
- OW_PR_FootstepsGrass_05
- OW_PR_FootstepsJumpIce_01
- OW_PR_ThrustRotationalUnderwater_01
- Anglerfish_Chase_Breathing
- OW_PR_FootstepsRock_04
- Metal Door Close Start
- Gear Rotate 1
- Airlock Loop
- Solanum_Foley_RockFormEnd
- mallowpuff3
- OW_PR_FootstepsSand_05
- OW_PR_FootstepsJumpRock_01
- Artifact Unfocus
- OW Eye Of The Universe 082818_2 AP
- OW_PR_FootstepsJumpRock_03
- galaxy_zoomout2
- OW_GD_IslandFalling_v2_loop
- Projector Previous Slide 2
- Ignite_CampFire_04
- SpaceshipAlarm2_3Iterations
- Ghost Individual Death 3
- OW_PR_FootstepsJumpNomai_01
- OW_PR_FootstepsJumpSnow_01
- Forest Oneshot - Animal 2
- OW_PR_FootstepsJumpDirt_01
- Dreamworld Tower Fall Part 1
- Ship_Impact_Medium_Damage_V3_05
- OW_NM_ComputerRing3
- OW_PR_SuitOn
- Airlock Pressurize
- OW_PR_FootstepsBushRustle_01
- OW_PR_FootstepsNomai_02
- Ship_Impact_Medium_Damage_V3_04
- OW_NM_VesselDiscovery
- PlayerSubmerge
- Player Gravel Footstep 5
- OW_EndTimes
- HGT_SandColumn_Ship
- OW ReelBeat 02c 021021 AP
- Spark_09
- OW_PR_FootstepsSand_02
- Damage_Light_05
- OW_NM_ComputerRingFall2
- gasp_traumatic7_lessmale
- Ghost Investigation Grunt
- Dream World Alarm Bell Oneshot 2
- rockingchair2
- OW_PR_FootstepsJumpDirt_04
- Projector Next Slide
- OW_PR_FootstepsSand_08
- OW_NM_WHAmbience2_v2
- drowning_secondhalf2
- Ghost Walk Footstep Forest 1
- Prisoner Cloth Foley 3
- OW_PR_FootstepsGlass_03
- Vision Torch Scanning - Loop
- Raft Medium Impact V2 2
- Hotel Oneshot - Heavy Thud 3
- Destruction Impact - Large 4
- OW_PR_FootstepsJumpLeaves_03
- OW_PR_FootstepsJumpSand_03
- OW Dreamworld Ruins SILENCE 02
- OW_PR_FootstepsWood_06
- ModelRocket_LightImpact
- shiplog_scanningloop
- OW Ghost Ambiences v2 011221 AP low LP
- OW NomaiRuinsRegular 081918 AP motif2c
- glass_crack_03
- Fix_Puncture_08
- OW_PR_FootstepsSnow_01
- OW_PR_FootstepsDirt_01
- asphyxiation_nosuit_firsthalf1
- OW_NM_DoorSlide_Big_LP_01
- OW_SUN_SupernovaWall
- OW_NM_DoorAirLockAirPourOut_03
- OW_PR_ThrustUnderwater
- Solar Sail Stop
- OW_TH_Waterwheel_loop
- Forest Oneshot - Tree Creak 1
- OW ReelBackdrop 03a 050321 LOOP
- Platform_Break_V2_04
- FireBall_01
- OW ReelBackdrop 01a 022521 AP
- Dreamworld Lights Out Ambience 1
- Nomai_Stone_Door_End_Big_V2_11
- Spark_07
- OW_SP_ThrustTranslationalUnderwater
- Dream World Water Ambience - Creek 1
- Ghost Begin Stalk Grunt 2
- Comet_Purr
- JellyFish_Shock_04
- OW_PR_FootstepsWood_08
- Raft Reeling Loop
- shiplog_switchmode_forward
- Station Light Flicker - Dreamworld
- Lantern Wake Up Light 3
- flashlightOn
- Dreamworld Base Ambience 1
- Ship_Impact_Heavy_Damage_V3_09
- Crushed_To_Death_V2_01
- ow_kazoo_theme
- JetPack_NotificationBeep
- Ghost Run Footstep Wood_v2 1
- OW_PR_FootstepsJumpNomai_05
- OW_NM_DataStream_v2
- UI_Tab_v2_02
- OW_PR_ProbeTakePicture
- OW_NM_GravityCannonAmbience
- OW NM Flashback 082818 AP loop
- OW_SP_LandingPadSoft4
- OW_PR_FootstepsGlass_07
- WarpCore_Insert_V3_01
- OW_NM_TractorBeamLP
- ShipRepair_Finish
- Ghost Begin Chase Grunt 1
- Destruction Impact 2
- OW_PR_FootstepsLeaves_08
- Recorder_Stop_Button
- OW_PR_FootstepsLeaves_04
- OW_PR_Jump1
- Jump_Into_TinyGalaxy_v2_04
- OW_GD_Tornado_v2_04
- OW_PR_FootstepsJumpDirt_02
- OW_SP_ConsoleReadoutStart
- OW_NM_EscapePodHatch
- OW_PR_FootstepsJumpNomai_02
- Light Sensor Fade In 1
- Light Sensor Fade In 2
- Hotel Oneshot - Creak 9
- CampfireTune_All_Reverb
- Recording_Loop_03
- PartyHouseWhistle_Confident
- mallowpuff4
- OW_NM_WhiteHoleAmbienceL
- Station Shudder
- drowning_firsthalf1
- UI_Exit_Dialog_V6-002_highpass
- Dream World Dam Break
- Dreamfire Extinguish 1
- MediumSplash
- Vision Torch - First Slide Appears
- Footstep1
- OW_TravelerTheme_drums
- Artifact Conceal
- HGT_Ambience_Cave_Small
- HGT_Ambience_Cave_Big
- OW_TH_Waterfall_loop_01
- OW Discovery 083021_2 AP darker shorter
- Secret Passageway Open Loop 2
- Hotel Oneshot - Creak 4
- supernova_explosion_deepnuclear2
- Ghost Shout 7
- OW NM Flashback 081718 AP slam
- Airlock Close
- OW_TH_FlagFlapping_loop.\_02
- OW_SP_RefuelJetpack_v2_short
- Ship_Impact_No_Damage_V3_03
- Raft Medium Impact V2 4
- Anglerfish_Awake3
- Wood Door Open Start
- OW_TH_FlagFlapping_loop
- Slide Reel Pickup 2
- Tronworld Ambience 2 Alex Hack
- Ghost Run Footstep Wood_v2 5
- Ignite_CampFire_03
- Single Ghost Scream 14
- Raft Start Reeling
- OW_PR_FootstepsGrass_08
- Tronworld Enter 2
- OW_PR_ProbeUnderwaterLaunch
- OW_GD_IslandCrashingInWater_v2
- Grapple Totem Zoom In
- OW ReelBeat 02a 021021 AP
- Nomai_Stone_Door_End_V2_08
- OW_PR_FootstepsJumpGlass_02
- OW_NM_DoorStart_02
- Destruction Impact - Large 3
- OW_SP_SignalscopeSlideV2
- OW NomaiRuinsRegular 081918 AP motif6c
- Wood Door Close Start 3 Alex
- Destruction Impact - Large 2
- Nomai_Stone_Door_End_Big_V2_01
- OW_NM_ComputerAmbienceLP
- Anglerfish_Awake2
- OW_TH_Insects_loop_03
- OW_PR_SignalscopeActivate
- OW_NM_ComputerRingFall1
- OW_PR_FootstepsDirt_02
- OW_NM_ShuttleLight
- Single Ghost Scream 1
- Ghost Identify Fail
- OW_SP_ShipGroan5_v2
- Cloaking Field Exit
- OW_PR_FootstepsNomai_01
- OW Dreamworld Ruins 072021 AP 02e
- Forest Oneshot - Tree Creak 2
- fogsphere_pulse1
- OW_PR_PullOutStick
- OW_PR_LockOn
- Nomai_Stone_Door_End_Big_V2_07
- OW_PR_FootstepsJumpSand_06
- InstantDeath2_Long_Ringing
- Light Sensor Door Stop 2
- Light Sensor Door Loop 2
- OW_TH_GeyserEnd_02
- pickaxe_01
- OW_PR_FootstepsWaterWade_03
- RockPile_Fall_03
- OW_PR_ThrustAfterburn_v2_01
- Light Sensor Fade Out 2
- Light Sensor Fade In 3
- OW Finally Set Free 072021_2 AP
- Ghost Blow Out Lantern Charge
- Wood Door Loop
- BigBang_Explo
- TH_Geyser_Loop_v3
- Water Spray Impact 8
- OW_TH_FlagFlapping_loop.\_03
- OW_PR_FootstepsJumpLeaves_02
- OW_PR_FootstepsIceSlide_Lp_01
- Dreamworld Lights Out Ambience 3
- knife_scrape_01
- OW OBSERVATORY 011317 AP
- Footstep_Run5
- Light Sensor Door Open 2
- Jetpack_O2_loop_01
- OW_PR_FootstepsJumpWood_04
- OW_SP_BuckleUp
- Probe_SnapShot_02
- Pickup_Ceramic_01
- OW_PR_FootstepsWood_03
- Destruction Debris 3
- OW_PR_SignalscopeDeactivate
- OW_PR_OxygenLeakingFromSuit_loop
- Probe_SnapShot_01
- Dreamworld Ghost Hotel Ambience 2
- Slide Reel Put Down 2
- Nomai_Stone_Door_End_V2_07
- OW_SP_ProbeLauncherRotation_v2
- OW_PR_MarshmallowEatUnburnt_noMmm_v3
- SystemBackOnline
- Ghost Idle Search 1
- Ship_Impact_Light_Damage_V3_03
- OW Dreamworld Ruins Story Beats 071621 AP 1i
- OW_PR_FootstepsGrass_02
- OW_NM_DoorSlide_LP_02
- Ringworld Cave Ambience
- Fix_Puncture_02
- OW_PR_FootstepsWaterWade_08
- OW_TH_GeyserStart_01
- OW_TH_Insects_loop_01
- OW ReelBeat 04d_2 040921 AP
- OW_TH_ProjectorStop
- Prisoner Cloth Foley 6
- Dream World Alarm Bell Oneshot 3
- shiplog_selectplanet2
- Nature Oneshot - Distant Creature 1 - less reverb
- OW_PR_FootstepsDirt_08
- Spark_04
- OW_GD_HeatLightning_02
- OW Secret Loop 090121 AP muted
- Creature Voice Test 1 Short
- General Destruction 4
- House Destruction 1
- OW_PR_FootstepsSnow_02
- Huge Splash 2
- Player Gravel Footstep 4
- Ghost Grab Player 1
- shiplog_switchmode_back
- OW_PR_FootstepsJumpWood_03
- OW_PR_FootstepsJumpMetal_05
- OW_SP_AutopilotEngaged 1
- OW_NM_DoorAirlockOpen_03
- OW Dreamworld Ruins 072021 AP 02b
- Ghost Investiagation Grunt 2
- Wood Door Close Start 2
- Real World Alarm Bell Oneshot 2
- OW Fabric SFX 102119 AP screen shatter SHORT
- OW_NM_Ruins_ambience_scary_loop
- Raft Heavy Impact 1
- OW Whispers 041321_2 AP LP
- Ghost Run Footstep Forest 4
- Vine_Crash_V3_01_LowPassDelay
- Solanum_Foley_HandLower
- OW_PR_FootstepsSand_07
- Grapple Totem Zoom Out Louder
- Ship_Impact_Heavy_Damage_V3_07
- OW_PR_FootstepsIce_01
- OW Ghost Ambiences v2 011221 AP pad LP
- Raft Movement Stop
- OW_TH_Museum
- gasp_normal12_lessmale
- OW_PR_FootstepsJumpRock_05
- OW_SP_ThrustRotationalUnderwater_02
- Pool_Exit_v3
- Flashlight_Malfunction_02
- OW NomaiRuinsRegular 081918 AP motif1c
- Nomai_Stone_Door_End_V2_05
- OW_PR_FootstepsLeaves_05
- Nomai_Stone_Door_End_V2_09
- asphyxiation_suit_secondhalf1
- Spark_08
- OW Aquatic Exploration 050318 AP LOOP
- OW_TH_GeyserEnd_01
- UI_Navigate_03
- OW ReelBeat 02b 021021 AP
- Player_Impact_Damage_Light_02
- OW_PR_FootstepsWood_02
- Jump_Into_TinyGalaxy_v2_02
- OW_PR_ThrustRotationalUnderwater_05
- Atmosphere_High_Suit
- OW_SP_MetalCreak_04
- OW Prisoner Reveal 063021 AP
- Ghost Grunt 1
- OW_PR_FootstepsJumpDirt_03
- OW Reelbeat 03c 061721 AP
- Nomai_Stone_Door_End_Big_V2_10
- Damage_Light_01
- PutDown_Rock_01
- OW_TH_ModelRocketCrashing
- OW ReelBeat 03b 032521 AP
- OW END OF GAME 021818 AP
- Raft Movement Start 3
- Impact_Light_03
- OW_NM_Tech_Advanced
- Ghost Walk Footstep Wood_v2 4
- OW_PR_FootstepsJumpWood_05
- OW_PR_FootstepsMetal_02
- FootstepsJumpWoodCreak_01
- OW Timber Hearth 032719 AP v2
- Hotel Oneshot - Heavy Creak 3
- shiplog_highlight
- OW_GD_Tornado_v2_03
- RotationalThruster02
- OW Quantum Lightning 091118 AP 06
- JetPack_NotificationBeep_Fast
- SmallSplash
- Ghost Run Footstep Forest 3
- Nomai_Stone_Door_End_Big_V2_04
- OW Prisoner Elevator 061121_5 AP loop
- Tower Fall Part 1
- OW_PR_FootstepsMetal_03
- OW_PR_FootstepsRock_01
- Ignite_Marshmallow_01
- Ignite_CampFire_02
- Ghost Walk Footstep Wood_v2 5
- OW_GD_AmbienceCave
- Ship_Impact_Heavy_Damage_V3_11
- Raft Release
- elevatorstop
- Hotel Oneshot - Creak 2
- Station Light Flicker
- Forest Oneshot - Tree Creak 7
- OW_GD_HeatLightning_03
- Nomai_Stone_Door_End_Big_V2_08
- OW_TH_AmbienceHighAltitude
- Water Spray Impact 3
- Ghost Grunt 2_SmoothFade
- linkingstone_out
- Ghost Shout 6
- Ghost Individual Death 4
- shiplog_highlight2
- OW_PR_FootstepsMetal_04
- OW Morning Cello 101718_2
- Spark_11
- fogsphere_jump2_delayed
- Nomai_Stone_Door_End_V2_04
- OW_SP_ElectricalDamageLP
- OW_PR_FootstepsGlass_02
- Ghost Run Footstep Forest 6
- OW_NM_CenterClampsRemoving
- OW_SP_ThrustRotationalUnderwater_03
- OW_NM_InsertScroll
- GhostMatter_Splash_v4_02
- Airlock Open
- OW_PR_TranslatorTranslateNew
- Ship_Impact_Heavy_Damage_V3_10
- House Destruction 2
- shiplog_newentry3_softer
- OW_TravelerTheme_piano
- Stilts Destruction 3
- OW_PR_LockOff
- OW_TH_ModelRocketThrustTranslational_01
- Hotel Oneshot - Creak 8
- Dreamworld Candle Lighting Test Variation 6
- Stilts Destruction 4
- OW_SUN_BurnPlanet
- Real World Dam Crack Water Loop
- OW Final End Times 022519_2 AP LOOP2
- OxygenRefill_Short
- OW ReelBeat 03a 031521 AP
- OW NomaiRuinsRegular 081918 AP motif5c v2
- StoryReel5Short 063021_3 AP
- OW_GD_AmbienceOcean
- OW_TH_BridgeCreaking_loop
- OW Traveler Theme 021821 AP FINAL TIME NO PIANO ADD PRISONER
- OW_SP_ShipAmbiance_01
- Prisoner Grunt 2
- OW_NM_ComputerRingFall3
- OW_NM_DoorStart_04
- Ghost Neck Snap
- Nomai_Warp_01
- General Destruction 2
- pickaxe_02
- OW_PR_FootstepsSnow_07
- Lava_Splash_02
- OW_PR_FootstepsGlass_06
- Anglerfish_Awake
- OW_PR_ProbeRetrieval
- OW_PR_FootstepsJumpSnow_04
- Lantern Wake Up Light 2
- Secret Passageway Open Stop 2
- Lantern Shorting Out 2
- OW_PR_BanjoStrum_1b
- OW_PR_FootstepsSnow_08
- Air Rushing Out Into Space
- OW_PR_FootstepsJumpGlass_03
- OW_PR_ProbeInAirSound
- shiplog_movebetweenplanets
- OW_PR_BanjoStrum_4b
- Raft Stop Reeling
- OW Traveler Theme 091118 AP FINAL TIME WITH PIANO EDIT
- OW_PR_FootstepsMetal_08
- OW ReelBeat 04a_2 040921 AP
- OW_SP_ShipExploding
- OW_PR_FootstepsJumpMetal_02
- OW_TH_ModelRocketThrustRotational_04
- JellyFish_Shock_03
- OW No-Eye Ruins 121120_2 AP LP
- OW_GD_HeatLightning_05
- OW_NM_GravityCrystalAmbience_Louder
- OW_GD_HeatLightning_07
- Solar Sail Loop 2
- OW_PR_FootstepsBushRustle_02
- CityLights_Off_01
- RotationalThruster01
- OW_NM_BHEnterItem_v2
- OW_PR_FootstepsBushRustle_09
- Vision Torch - Vision Dissolves
- OW_PR_FootstepsJumpMetal_04
- Lantern Remove 2
- Player_Impact_Damage_Light_01
- StoryReel5Full 062821_4 AP
- OW_PR_FootstepsWaterWade_07
- OW_NM_SkypeLP
- OW_SP_ShipGroan2_v2
- Volcano_Ambience_Loop_V2
- AnglerFish_Chomp_Loop_v2
- Destruction Debris 2
- OW_PR_LandInWater2
- OW_PR_FootstepsIce_05
- Footstep_Run1
- Anglerfish_ChompBite_01
- Destruction Debris 1
- Ghost Run Footstep Forest 1
- AnglerFish_Target_v2_02
- Signalscope_Zoom_Loop
- BH_Ambience_Below_Crust
- fogsphere_pulse3
- OW_GD_HeatLightning_08
- AshTwinCore_Close_01
- Airlock Depressurize
- OW_TH_ModelRocketThrustRotational_03
- OW_NM_ComputerRing2
- RockPile_Fall_05
- Vision Torch Fire - Loop
- OW Farewell 061721 AP
- Hologram_Enter_v2_01
- OW_PR_ThrustRotationalUnderwater_03
- Forest Oneshot - Tree Creak 8
- OW_PR_LandInWater3
- Hotel Oneshot - Creak 3
- Hotel Oneshot - Heavy Thud 1
- Distant Ghost Cacophony 1
- Footstep_Run2
- OW_TH_ProjectorRun_loop
- OW_PR_FootstepsJumpGrass_04
- Destruction Impact - Large 5
- FootstepsWoodCreak_03
- OW_PR_FootstepsIce_03
- Solanum_Foley_HandRaise
- OW_NM_DoorStart_Big_03
- Candle Extinguishing Test Variation 6
- Ignite_CampFire_01
- Nature Oneshot - Distant Creature 3 - less reverb
- Real World Water Ambience - Slow River
- Ghost Grunt 5
- IceMelt_v2_LowPass
- OW_NM_GravityCannonDeactivated
- OW Ghost Sequence 011121 AP LOW SUSPENSE LP
- Anglerfish_Sleeping
- Real World Water Ambience - Slow River 2
- OW_PR_FootstepsWaterWade_02
- Ghost Walk Footstep Forest 3
- Spark_05
- OW No-Eye Ruins 082121 AP stinger
- Nature Oneshot - Distant Deep Creature 3
- OW_NM_SunStation
- Projector Totem Extinguish 1
- Dreamfire Crackling Loop 3
- OW Ghost Ambiences 012921_2 AP slam
- Dreamfire Explosion
- Dream World Water Ambience - Creek 8
- OW_PR_FootstepsSnow_05
- OW_PR_FootstepsIce_04
- Dream World Water Ambience - Creek 5
- Ghost Run Footstep Forest 2
- OW_NM_DoorStart_08
- Outer Wilds Party House v8 050321_2 AP traveler drone
- Hotel Oneshot - Heavy Creak 1
- Secret Passageway Open Start 2
- FootstepsWoodCreak_01
- Ghost Grunt 8
- OW_PR_FootstepsMetal_06
- Probe_Attach_v3_02
- OW_PR_LandInWater1
- FootstepsWoodCreak_06
- OW_PR_FootstepsBushRustle_04
- Projector Totem Blow
- OW_PR_FootstepsWaterWade_01
- Raft Movement Loop
- OW_SP_ThrustRotationalUnderwater_01
- OW_PR_FallingIntoLavaBeep_loop
- Ship_Impact_Light_Damage_V3_01
- Ship_Impact_Medium_Damage_V3_02
- Ghost Walk Footstep Wood_v2 1
- Nomai_Stone_Door_End_Big_V2_02
- OW ReelBeat 04c_2 040921 AP
- Raft Push
- OW_PR_FootstepsJumpIce_03
- Nomai_Stone_Door_End_Big_V2_05
- Destruction Impact 5
- HGT_SandFallSmall_Inside
- OW Quantum Lightning 091118 AP 01
- OW_PR_OxygenLeakingFromSuit_in
- OW_PR_HelmetOn
- OW_SP_AutopilotDisengaged 1
- PutDown_Ceramic_01
- OW_PR_FootstepsMetal_07
- Water Spray Impact 7
- Dream World Alarm Bell Oneshot 4
- CityLights_On_01
- rockingchair3
- fogsphere_pulse5
- Nomai_ShipPowerOn_V2_01
- OW_GD_IslandSuckedInTornado
- OW_NM_DoorStart_05
- Probe_Attach_v3_01
- OW_PR_ThrustRotationalUnderwater_02
- Outer Wilds Party House v8 050321_3 AP traveler
- Artifact Put Down
- OW ReelBeat 01b 021021 AP
- stoppedasphyxiating_suit2
- FootstepsJumpWoodCreak_04
- Destruction Debris 6
- Nomai_Warp_03_Shorter
- mallowpuff1
- OW ReelBeat 02d 021021 AP
- OW_TravelerTheme_harmonica
- shiplog_misc4
- Projector Totem Extinguish 3
- OW ReelBackdrop 02b 021021 AP
- OW_PR_FootstepsDirt_03
- Lava_Splash_01
- Engine_Start_V2
- Solar Sail Start
- OW_PR_ThrustTranslational_v2_01
- Light Sensor Fade Out 1
- Prisoner Cloth Foley 4
- OW Quantum Lightning 091118 AP 02
- OW_NM_RemoveScroll
- asphyxiation_suit_firsthalf2
- OW_TH_AmbienceNightInCanyons
- Footstep2
- OW ReelBackdrop 03b LOOP 031521 AP
- OW_SP_ThrustRotationalUnderwater_04
- OW_PR_FootstepsNomai_08
- OW_PR_FootstepsNomai_03
- OW ReelBeat 03d 061121 AP
- OW_PR_FootstepsJumpSand_04
- RotationalThruster03
- Stilts Destruction 5
- Raft Run Aground
- OW Space Station 081420_2 AP
- OW_PR_FootstepsWaterWade_06
- Spark_02
- Cloaking Field Entry
- OW_NM_DataWormhole
- OW_QuantumSignal
- General Destruction 3
- OW New Raft Music 082321_4 AP quiet
- OW_SP_Unbuckle
- Real World Water Ambience - Calm 2
- Prisoner Grunt 3
- OW_NM_OrbMoveGlass_lp_01
- Prisoner Cloth Foley 7
- OW_PR_FootstepsRock_05
- OW Traveler Theme 021821 AP FINAL TIME WITH PIANO ADD PRISONER
- OW Quantum Lightning 091118 AP 03
- OW_TH_ModelRocketThrustRotational_02
- OW_PR_HitWallUnderwater3
- Flashlight_Malfunction_03
- OW NM Flashback 082818 loop overlay AP
- supernova_corecollapse_10sec_fadeOut
- OW_PR_FootstepsWood_05
- rockingchair1
- Power_Failure_v2_02
- OW_PR_FootstepsMetal_05
- Stilts Destruction 2
- Dreamworld Tower Tilt
- OW New Texture 082921 AP loop
- Lantern Insert 3
- OW_PR_FootstepsNomai_07
- OW_PR_FootstepsJumpWood_06
- Pool_Enter_v3_Fade
- Raft Movement Start
- OW_PR_FootstepsNomai_05
- OW_PR_HardSplash
- Destruction Debris 5
- Dreamworld Candle Lighting Test Variation 2
- OW NM Flashback 082818_2 AP stinger delayed
- Ghost Shout 4
- Nomai_Stone_Door_End_Big_V2_06
- Tower Tilt
- OW_NM_DoorStart_Big_06
- OW_PR_FootstepsLeaves_03
- Ghost Run Footstep Wood_v2 3
- OW_NM_BHExitItem_v2
- Ghost Idle Search 5
- Forest Oneshot - Animal 1
- OW Dreamworld Ruins 072021 AP 02d
- OW_PR_FootstepsJumpSnow_02
- Platform_Break_V2_01
- OW Party House 092820 AP short loop
- OW_PR_FootstepsRock_06
- OW_SP_ThrustTranslational
- Footstep6
- OW_PR_FootstepsWaterWade_05
- Ghost Start Hunt Grunt 2
- OW Dreamworld Ruins 072021 AP 02f
- Nomai_Stone_Door_End_Big_V2_12
- Jump_Into_TinyGalaxy_v2_03
- Footstep_Run3
- Negative1
- OW_TravelerTheme_banjo
- SandColumnEnd_v2
- OW_PR_FootstepsJumpSand_05
- Dreamworld Lights Out Ambience 2
- OW Blair Witch Project 082921_3 AP darker mix loop
- Fig_Backer_Sat_Audio_V3
- OW_PR_FootstepsGlass_01
- Light Sensor Fade Out 4
- Projector Totem Light 1
- Player Gravel Footstep 6
- OW_TH_GeyserStart_03
- Slide Reel Remove 3
- Ship_Impact_Medium_Damage_V3_06
- OW Quantum Lightning 091118 AP 05
- OW_GD_Tornado_v2_01
- OW_SP_ActivateComputerLP
- Footstep_Run6
- Spark_13
- Vine_Crash_V3_02_LowPassDelay
- OW Slideshow BURNT LOOP small 031521_2 AP
- Raft Heavy Impact 4
- Light Sensor Door Loop - Door Sensor Sliding
- Sarcophagus Strain 3
- Loading Tunnel - Load
- elevatorstart
- Nomai_Stone_Door_End_V2_02
- OW_GD_Tornado_v2_02
- OW_NM_DoorAirLockAirPourOut_01
- OW_TravelerTheme_newtraveler 061021 AP
- OW ReelBackdrop 04a_3 041321 AP LP
- OW_PR_FootstepsJumpRock_04
- Damage_Heavy_04
- Raft Movement Stop 2
- OW_SP_AnalogClick2_v2
- Nomai_Stone_Door_End_V2_01
- OW_PR_FootstepsRock_07
- Raft Light Impact V2 4
- Marshmallow_Replace_01
- Footstep5
- Destruction Impact 3
- Helmet_Glass_Crack_08
- Ghost Run Footstep Wood_v2 6
- OW End Credits 022019_3 AP
- Raft Heavy Impacts V2 2
- Nomai_Stone_Door_End_Big_V2_13
- OW_NM_GravityCannonActivated
- Outer Wilds Party House v8 050321_2 AP Bass
- Ringworld Muffled Indoor Ambience
- Ghost Run Footstep Wood_v2 2
- OW_GD_AmbienceUndewater
- Forge_Loop_V3_03
- OW_PR_CampfireAmbience
- OW_PR_FootstepsRock_08
- Platform_Break_V2_02
- OW_PR_FootstepsJumpWood_02
- OW Eye Temple 121820_2 AP LP
- OW_GD_WavesAgainstBeach
- OW_PR_ThrowProbe
- OW_NM_DoorStart_07
- OW_PR_FootstepsSand_04
- Lantern Pickup
- Real World Water Ambience - Rapids 2
- OW_PR_FootstepsWood_04
- OW_NM_TractorBeamPowerUp
- OW New Stinger 082921 AP
- OW_PR_FootstepsGrass_07
- Hotel Oneshot - Creak 7
- Player_On_Fire_Loop
- OW_TH_UnderwaterRushing
- GhostMatter_Splash_v4_01
- OW_SP_ThrustRotationalUnderwater_06
- OW Fabric SFX 102119 AP rip FADE OUT
- OW Dreamworld Ruins 072021 AP 02a
- Spark_06
- OW_SP_SignalscopeChunkV2
- Player Gravel Footstep 2
- OW_PR_FootstepsBushRustle_07
- Hologram_Exit_v2_01
- Metal Door Open Stop
- OW_PR_FootstepsJumpWood_01
- OW_PR_FootstepsWaterWade_04
- Nature Oneshot - Distant Deep Creature 2
- Stilts Destruction 1
- OW NM Flashback 082818 AP overlay1
- drowning_secondhalf1
- Gear Rotate Locked_Short
- Prisoner Cloth Foley 5
- shiplog_deselectplanet
- Orb_End_v3_01
- Atmosphere_High_Ship
- Solar Sail Start 2
- knife_scrape_02
- OW_TH_GeyserEnd_03
- Meteor_Impact_03_b
- Destruction Impact 6
- JellyFish_Shock_01
- Light Sensor Loop
- Candle Extinguishing Test Variation 4
- Vision Torch Light Rays - Off
- OW_NM_DoorSlide_Big_LP_05
- OW_PR_FootstepsDirt_05
- Sand_Column_Start_v2_03
- Water Spray Impact 6
- OW_NM_DoorStart_Big_07
- OW_SP_ShipGroan3_v2
- Heat_Damage_Loop_01
- OW_SP_LandingCamDeactivated 1
- breathing_lowO2_6
- OW_PR_OxygenLeakingFromSuit_out
- LogUpdated_001
- Vine_Crash_V3_04_LowPassDelay
- Destruction Debris 7
- Hotel Oneshot - Heavy Creak 2
- OW_PR_HelmetOff
- OW_PR_FootstepsGrass_04
- Forest Oneshot - Animal 3
- OW Discovery 083021_2 AP shorter
- Slide Reel Insert 3
- OW_NM_BHEnterExitPlayer_v2
- Ship_Impact_Light_Damage_V3_05
- OW_SP_OpenHatch_NoBeep
- OW_SP_ThrustRotationalUnderwater_05
- ShipSubmerge
- Artifact Fire Loop
- OW_DarkBramble_loop
- OW_PR_FootstepsBushRustle_08
- OW NM Nomai City 081718 AP LOOP
- Solar Sail Stop 2
- Destruction Impact - Large 1
- OW Dream Rule LP 032421 AP normal
- Solar Sail Loop
- OW_TH_GeyserStart_02
- Ship_Impact_No_Damage_V3_05
- OW_PR_FootstepsIce_06
- Outer Wilds Party House v8 050321_2 AP vocals
- asphyxiation_suit_secondhalf2
- Affirmative1
- Spark_12
- OW_SP_ConsoleReadoutLP
- OW ReelBackdrop 03c 042621 AP LP
- gasp_light9
- Nomai_Stone_Door_End_V2_03
- OW_PR_FootstepsJumpNomai_06
- OW_PR_FootstepsGlass_04
- OW_PR_FootstepsDirt_04
- Destruction Debris 9
- OW_PR_FootstepsIce_08
- OW_PR_SuitOff
- Artifact Pickup
- OW_SUN_Ambience_v4
- JellyFish_Shock_05
- OW_TH_Underwater
- Station Shudder - Dreamworld
- Ghost Walk Footstep Forest 5
- OW_TH_ProjectorActivate
- asphyxiation_suit_firsthalf1
- OW_PR_SignalscopeZoomIn
- HGT_Ambience_Surface
- FootstepsWoodCreak_08
- GhostMatter_Splash_v4_03
- UI_Tab_v2_05
- Raft Medium Impact V2 3
- OW_NM_TractorBeamPowerDown
- OW_Travel_Theme_Remaster
- Big_Galaxy_Burn_v2_01
- OW_TH_Insects_loop_02
- Raft Heavy Impact 3
- Raft Movement Start 2
- OW Quantum Lightning 091118 AP 04
- OW_TH_FlagFlapping_loop.\_04
- OW_TH_ModelRocketThrustTranslational_02
- knife_scrape_03
- Incinerate_v3_02
- Light Sensor Rotate
- OW_NM_EscapePodDistressSignal
- MapZoomOut_Tone
- OW_NM_DoorStart_Big_05
- Player Gravel Footstep 7
- Ghost Walk Footstep Wood_v2 2
- Ghost Run Footstep Forest 5
- Ghost Walk Footstep Forest 4
- OW_PR_HitWallUnderwater2
- OW NM Flashback 082818_2 AP stinger
- OW_PR_FootstepsJumpGrass_05
- Fix_Puncture_04
- Ghost Idle Search 3
