using NewHorizons.Utility.OWML;
using UnityEngine;
using UnityEngine.SceneManagement;

namespace NewHorizons.Handlers
{
    public static class InvulnerabilityHandler
    {
        /// <summary>
        /// Used in patches
        /// </summary>
        public static bool Invincible { get; private set; }

        public static void MakeInvulnerable(bool invulnerable)
        {
            NHLogger.Log($"Toggling immortality: {invulnerable}");

            Invincible = invulnerable;
            var deathManager = GetDeathManager();
            var resources = GetPlayerResouces();

            if (invulnerable)
            {
                deathManager._invincible = true;
                resources._invincible = true;
            }
            else
            {
                resources._currentHealth = 100f;
                deathManager._invincible = false;
                resources._invincible = false;
            }
        }

        private static DeathManager _deathManager;
        private static DeathManager GetDeathManager()
        {
            if (_deathManager == null)
            {
                _deathManager = GameObject.FindObjectOfType<DeathManager>();
            }
            return _deathManager;
        }

        private static PlayerResources _playerResources;
        private static PlayerResources GetPlayerResouces()
        {
            if (_playerResources == null)
            {
                _playerResources = GameObject.FindObjectOfType<PlayerResources>();
            }
            return _playerResources;
        }

        static InvulnerabilityHandler()
        {
            // If the scene unloads when Invincible is on it might not get turned off
            SceneManager.sceneUnloaded += (_) => Invincible = false;
        }
    }
}
