# 厨房准备

在阅读和参考菜谱之前，假想你已经在厨房中准备好了下列物品。这些物品不会在原材料和工具部分提及。

```text
燃气灶，饮用水，炒锅，蒸锅，煮锅，电饭锅，食用油，洗菜盆，碟子，碗，筷子，勺子，汤勺，漏勺，洗涤剂，抹布，钢丝球，菜刀，生食案板，熟食案板，削皮刀，热水壶
```

下列材料可能会被高频使用。建议提前为厨房采购好，并永远保障有新鲜的可以取用。

```text
大葱，小葱，生姜，大蒜，花椒，八角，桂皮，香叶
干辣椒，小米椒，生抽，老抽，蚝油，料酒（黄酒，可选）
黑醋(香醋、陈醋)，白醋，豆瓣酱，冰糖，棉白糖，盐，味精\鸡精
黑胡椒，白胡椒，五香粉，玉米淀粉，番薯淀粉
```

如果你需要应对突发情况或长期居家需求，建议同样采购好下列内容：

```text
冰箱、微波炉、保鲜膜、保鲜袋
鸡蛋、青椒、胡萝卜、黄瓜、西红柿、木耳、里脊肉、茄子、米、挂面或方便面
```

如果你非常想追求形式化、标准化和仪式感，并且想拥有一个与众不同的有趣厨房，那就同样采购下列内容：

```text
电子秤（或天平）、游标卡尺、量筒、停表、烧杯、测温枪、移液器
```

如果你想节约时间，可以购买半成品并简单处理后食用：

```text
预炸过的炸鸡块、冷冻手抓饼、包好的饺子、袋装咖喱、各种丼类（盖饭）、自热食品、拌面料包、外卖包、方便食品
```

其它针对每道菜的原材料，请具体参考菜品本身的`所需原材料`章节。

## 选购油

在选购油之前，需要了解一些脂肪酸的基础知识

### 脂肪酸的分类

脂肪酸分为：

* 饱和脂肪酸 （尽量避免）
* 不饱和脂肪酸
  * 顺式脂肪酸
  * 反式脂肪酸 （尤其注意避免）
  * 多不饱和脂肪酸
  * 单不饱和脂肪酸

饱和脂肪酸在室温下会呈固态，而不饱和脂肪酸在室温下会呈液态。

### 避免的脂肪酸

其中，**饱和脂肪酸**和**反式脂肪酸**一般是被认为不健康的。

饱和脂肪酸会增加肥胖、高胆固醇、心脏病的风险。

研究表明，长期过量食用氢化加工产生的反式脂肪酸可引起人体血脂代谢异常，从而增加心血管疾病发生的风险。也有研究显示可能会增加糖尿病、肥胖等慢性疾病的患病风险。

世界卫生组织建议：为增进心血管健康，应尽量控制膳食中的反式脂肪酸，最大摄取量不超过总能量的 1%。也就是说，如果按一个成年人平均每天摄入能量 2000 千卡来算，则每天摄入反式脂肪酸不应超过 2.2 克。

GB 28050-2011 规定，食品配料含有或生产过程中使用了氢化和（或）部分氢化油脂时，在营养成分表中还应标示出反式脂肪（酸）的含量。

### 食品中的的反式脂肪酸

根据相关调查，焙烤食品（糕点、饼干、面包等）、调味品、油炸食品的反式脂肪酸平均含量在 0.30~0.50 g/100g 之间。

因此不必太过担心——日常食品中的反式脂肪酸并不足以危害健康。但以防万一，在选购零食时，不妨关注营养成分表中标注的 `反式脂肪（酸）` 含量。

### 烹饪中的反式脂肪酸

据 2021 年调查显示，我国植物油的反式脂肪酸平均含量为 0.86 g/100g，无需太过担心。

要额外注意的反式脂肪酸来源是烹饪过程：

植物油中往往含有较高比例的多不饱和脂肪酸，热稳定性比较差，容易在高温下转化成反式脂肪。

因此，在不同场景下，我们需要合理选择油品，并尽可能减少油品的加热时间。

### 植物油的选择

| 油品名称 | 饱和脂肪酸 (%) | Omega 3 (%) | Omega 6 (%) | Omega 9 (%) |
| :----: | :----: | :----: | :----: | :----: |
| 芥花油 | 7% | 11% | 21% | 61% |
| 亚麻籽油 | 9% | 57% | 16% | 18% |
| 葵花油 | 12% | 1% | 71% | 16% |
| 玉米油 | 13% | 1% | 57% | 29% |
| 橄榄油 | 15% | 1% | 9% | 75% |
| 大豆油 | 15% | 8% | 54% | 23% |
| 花生油 | 19% | 0% | 33% | 48% |
| 棉籽油 | 27% | 0% | 54% | 19% |
| 猪油 | 43% | 1% | 9% | 47% |
| 棕榈油 | 51% | 0% | 10% | 39% |
| 牛油 | 68% | 1% | 3% | 28% |
| 椰子油 | 91% | 0% | 2% | 7% |

* `花生油`富含`单不饱和脂肪`。但只建议选择高品质的。加工时也要注意不要加热过久以免产生`反式脂肪酸`。
* `橄榄油`富含`单不饱和脂肪`，其只有一个不饱和键。橄榄油`饱和脂肪酸`含量少。但只建议选择高品质的。加工时也要注意不要加热过久以免产生反式脂肪酸。
* `大豆油`不含`饱和脂肪酸`，且含有亚油酸、维生素。但大豆油不稳定，容易在加工时产生`反式脂肪酸`，因此不建议长期食用，可以用于凉拌。
* `菜籽油`热稳定性好，富含`多不饱和脂肪酸`，但可能含有芥酸，可能会引起脂肪沉积和心脏损伤。菜籽油缺少亚油酸，营养价值较低，容易腐败。
* `椰子油`的`饱和脂肪酸`非常高，热稳定性好，但注意有些食品会使用氢化椰子油。适合在厨房用于煎炸，经常食用会增加肥胖风险。
* `棕榈油`的`饱和脂肪酸`非常高，热稳定性好，经常食用会增加高胆固醇风险。
* `猪油`，`牛油`等动物油脂，富含`饱和脂肪酸`，经常食用会增加高胆固醇风险。不推荐长期食用。

因此，根据上述表格，我们可以得出一些结论：

* 没有任何一种油品是完美的，每种油品都有其优缺点。因此，我们应该根据不同的烹饪场景选择不同的油品。
* 不应该始终使用同一类油品，应该根据不同的烹饪场景选择不同的油品，以确保营养均衡。
* 为了不摄入太多 `反式脂肪酸`。在加热时，不要选择热不稳定的油品，不要加热过久。
* 不要大量食用煎炸食品。热稳定性好的油往往又含有大量的`饱和脂肪酸`，不适合长期食用。
* 不要重复使用油品。油品在加热过程中会产生大量的`反式脂肪酸`。
* 不要长时间食用外卖食品，因为很难确定他们使用了什么油品。

#### 炒菜油

* 花生油 （选择高油品质）
* 橄榄油 （选择高油品质）
* 菜籽油 （选择低芥酸）

花生油、橄榄油、菜籽油含有较多不饱和脂肪酸，含有较少的饱和脂肪酸。但是其热稳定性较差，容易在加热过程中产生反式脂肪酸。因此，要注意控制加热时间，不要加热过久。

#### 煎炸油

* 椰子油
* 棕榈油
* 牛油
* 猪油

爆炒、油炸时需要使用热稳定性更好的油，如：椰子油、棕榈油、牛油。它们产生的反式脂肪酸会更少。但是，它们的饱和脂肪酸含量较高，不适合长期食用。

#### 凉拌、炖煮油

* 亚麻籽油
* 芝麻油
* 核桃油
* 紫苏油

这类场景不需要加热，因此不会产生反式脂肪酸。不要选择有太多饱和脂肪酸的油品。
