/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.logging;

import com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.logging.events.CategorisedOutputEvent;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.sink.OutputEventListenerManager;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scopes.BuildSession.class})
public class LoggingBuildOperationProgressBroadcaster
implements Stoppable,
OutputEventListener {
    private final OutputEventListenerManager outputEventListenerManager;
    private final BuildOperationProgressEventEmitter progressEventEmitter;
    @VisibleForTesting
    OperationIdentifier rootBuildOperation;

    public LoggingBuildOperationProgressBroadcaster(OutputEventListenerManager outputEventListenerManager, BuildOperationProgressEventEmitter progressEventEmitter) {
        this.outputEventListenerManager = outputEventListenerManager;
        this.progressEventEmitter = progressEventEmitter;
        outputEventListenerManager.setListener((OutputEventListener)this);
    }

    public void onOutput(OutputEvent event) {
        if (event instanceof RenderableOutputEvent) {
            RenderableOutputEvent renderableOutputEvent = (RenderableOutputEvent)event;
            OperationIdentifier operationIdentifier = renderableOutputEvent.getBuildOperationId();
            if (operationIdentifier == null) {
                if (this.rootBuildOperation == null) {
                    return;
                }
                operationIdentifier = this.rootBuildOperation;
            }
            if (renderableOutputEvent instanceof StyledTextOutputEvent || renderableOutputEvent instanceof LogEvent) {
                this.emit((CategorisedOutputEvent)renderableOutputEvent, operationIdentifier);
            }
        } else if (event instanceof ProgressStartEvent) {
            ProgressStartEvent progressStartEvent = (ProgressStartEvent)event;
            if (progressStartEvent.getLoggingHeader() == null) {
                return;
            }
            OperationIdentifier operationIdentifier = progressStartEvent.getBuildOperationId();
            if (operationIdentifier == null && this.rootBuildOperation != null) {
                operationIdentifier = this.rootBuildOperation;
            }
            this.emit((CategorisedOutputEvent)progressStartEvent, operationIdentifier);
        }
    }

    private void emit(CategorisedOutputEvent event, OperationIdentifier buildOperationId) {
        this.progressEventEmitter.emit(buildOperationId, event.getTimestamp(), (Object)event);
    }

    public void stop() {
        this.outputEventListenerManager.removeListener((OutputEventListener)this);
    }

    public void rootBuildOperationStarted() {
        this.rootBuildOperation = CurrentBuildOperationRef.instance().getId();
    }
}

