/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.webwolf.jwt;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwx.CompactSerializer;
import org.jose4j.keys.HmacKey;
import org.jose4j.lang.JoseException;
import org.owasp.webgoat.webwolf.jwt.JWTToken;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class JWTToken {
    private String encoded = "";
    private String secretKey;
    private String header;
    private boolean validHeader;
    private boolean validPayload;
    private boolean validToken;
    private String payload;
    private boolean signatureValid = true;

    public static JWTToken decode(String jwt, String secretKey) {
        JWTToken token = JWTToken.parseToken((String)jwt.trim().replace(System.getProperty("line.separator"), ""));
        return token.toBuilder().signatureValid(JWTToken.validateSignature((String)secretKey, (String)jwt)).build();
    }

    private static Map<String, Object> parse(String header) {
        ObjectMapper reader = new ObjectMapper();
        try {
            return (Map)reader.readValue(header, TreeMap.class);
        }
        catch (JsonProcessingException e) {
            return Map.of();
        }
    }

    private static String write(String originalValue, Map<String, Object> data) {
        ObjectWriter writer = new ObjectMapper().writerWithDefaultPrettyPrinter();
        try {
            if (data.isEmpty()) {
                return originalValue;
            }
            return writer.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            return originalValue;
        }
    }

    public static JWTToken encode(String header, String payloadAsString, String secretKey) {
        Map headers = JWTToken.parse((String)header);
        Map payload = JWTToken.parse((String)payloadAsString);
        JWTTokenBuilder builder = JWTToken.builder().header(JWTToken.write((String)header, (Map)headers)).payload(JWTToken.write((String)payloadAsString, (Map)payload)).validHeader(!StringUtils.hasText((String)header) || !headers.isEmpty()).validToken(true).validPayload(!StringUtils.hasText((String)payloadAsString) || !payload.isEmpty());
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(payloadAsString);
        headers.forEach((k, v) -> jws.setHeader(k, v));
        if (!headers.isEmpty()) {
            builder.encoded(CompactSerializer.serialize((String[])new String[]{jws.getHeaders().getEncodedHeader(), jws.getEncodedPayload()}));
        }
        if (!headers.isEmpty() && !payload.isEmpty() && StringUtils.hasText((String)secretKey)) {
            jws.setDoKeyValidation(false);
            jws.setKey((Key)new HmacKey(secretKey.getBytes(StandardCharsets.UTF_8)));
            try {
                builder.encoded(jws.getCompactSerialization());
                builder.signatureValid(true);
            }
            catch (JoseException joseException) {
                // empty catch block
            }
        }
        return builder.build();
    }

    private static JWTToken parseToken(String jwt) {
        String[] token = jwt.split("\\.");
        JWTTokenBuilder builder = JWTToken.builder().encoded(jwt);
        if (token.length >= 2) {
            String header = new String(Base64.getUrlDecoder().decode(token[0]), StandardCharsets.UTF_8);
            String payloadAsString = new String(Base64.getUrlDecoder().decode(token[1]), StandardCharsets.UTF_8);
            Map headers = JWTToken.parse((String)header);
            Map payload = JWTToken.parse((String)payloadAsString);
            builder.header(JWTToken.write((String)header, (Map)headers));
            builder.payload(JWTToken.write((String)payloadAsString, (Map)payload));
            builder.validHeader(!headers.isEmpty());
            builder.validPayload(!payload.isEmpty());
            builder.validToken(!headers.isEmpty() && !payload.isEmpty());
        } else {
            builder.validToken(false);
        }
        return builder.build();
    }

    private static boolean validateSignature(String secretKey, String jwt) {
        if (StringUtils.hasText((String)secretKey)) {
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setVerificationKey((Key)new HmacKey(secretKey.getBytes(StandardCharsets.UTF_8))).setRelaxVerificationKeyValidation().build();
            try {
                jwtConsumer.processToClaims(jwt);
                return true;
            }
            catch (InvalidJwtException e) {
                return false;
            }
        }
        return false;
    }

    @Generated
    public static JWTTokenBuilder builder() {
        return new JWTTokenBuilder();
    }

    @Generated
    public JWTTokenBuilder toBuilder() {
        return new JWTTokenBuilder().encoded(this.encoded).secretKey(this.secretKey).header(this.header).validHeader(this.validHeader).validPayload(this.validPayload).validToken(this.validToken).payload(this.payload).signatureValid(this.signatureValid);
    }

    @Generated
    public JWTToken() {
    }

    @Generated
    public JWTToken(String encoded, String secretKey, String header, boolean validHeader, boolean validPayload, boolean validToken, String payload, boolean signatureValid) {
        this.encoded = encoded;
        this.secretKey = secretKey;
        this.header = header;
        this.validHeader = validHeader;
        this.validPayload = validPayload;
        this.validToken = validToken;
        this.payload = payload;
        this.signatureValid = signatureValid;
    }

    @Generated
    public String getEncoded() {
        return this.encoded;
    }

    @Generated
    public String getSecretKey() {
        return this.secretKey;
    }

    @Generated
    public String getHeader() {
        return this.header;
    }

    @Generated
    public boolean isValidHeader() {
        return this.validHeader;
    }

    @Generated
    public boolean isValidPayload() {
        return this.validPayload;
    }

    @Generated
    public boolean isValidToken() {
        return this.validToken;
    }

    @Generated
    public String getPayload() {
        return this.payload;
    }

    @Generated
    public boolean isSignatureValid() {
        return this.signatureValid;
    }

    @Generated
    public void setEncoded(String encoded) {
        this.encoded = encoded;
    }

    @Generated
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Generated
    public void setHeader(String header) {
        this.header = header;
    }

    @Generated
    public void setValidHeader(boolean validHeader) {
        this.validHeader = validHeader;
    }

    @Generated
    public void setValidPayload(boolean validPayload) {
        this.validPayload = validPayload;
    }

    @Generated
    public void setValidToken(boolean validToken) {
        this.validToken = validToken;
    }

    @Generated
    public void setPayload(String payload) {
        this.payload = payload;
    }

    @Generated
    public void setSignatureValid(boolean signatureValid) {
        this.signatureValid = signatureValid;
    }
}

