/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.webwolf;

import lombok.Generated;
import org.owasp.webgoat.container.AjaxAuthenticationEntryPoint;
import org.owasp.webgoat.webwolf.user.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.NoOpPasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig {
    private final UserService userDetailsService;

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)http.authorizeHttpRequests(auth -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/css/**", "/webjars/**", "/favicon.ico", "/js/**", "/images/**"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(HttpMethod.GET, new String[]{"/fileupload/**", "/files/**", "/landing/**", "/PasswordReset/**"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(HttpMethod.POST, new String[]{"/files", "/mail", "/requests"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).authenticated();
        }).csrf(csrf -> csrf.disable()).formLogin(login -> ((FormLoginConfigurer)((FormLoginConfigurer)login.loginPage("/login").failureUrl("/login?error=true")).defaultSuccessUrl("/home", true)).usernameParameter("username").passwordParameter("password").permitAll()).oauth2Login(oidc -> oidc.defaultSuccessUrl("/home")).logout(logout -> logout.deleteCookies(new String[]{"WEBWOLFSESSION"}).invalidateHttpSession(true)).exceptionHandling(handling -> handling.authenticationEntryPoint((AuthenticationEntryPoint)new AjaxAuthenticationEntryPoint("/login"))).build();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService((UserDetailsService)this.userDetailsService);
    }

    @Bean
    public UserDetailsService userDetailsServiceBean() {
        return this.userDetailsService;
    }

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationConfiguration authenticationConfiguration) throws Exception {
        return authenticationConfiguration.getAuthenticationManager();
    }

    @Bean
    public NoOpPasswordEncoder passwordEncoder() {
        return (NoOpPasswordEncoder)NoOpPasswordEncoder.getInstance();
    }

    @Generated
    public WebSecurityConfig(UserService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

