/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.xxe;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.StringReader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.owasp.webgoat.container.users.WebGoatUser;
import org.owasp.webgoat.lessons.xxe.Comment;
import org.owasp.webgoat.lessons.xxe.CommentsCache;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class CommentsCache {
    private static final Comments comments = new Comments();
    private static final Map<WebGoatUser, Comments> userComments = new HashMap();
    private static final DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd, HH:mm:ss");

    public CommentsCache() {
        this.initDefaultComments();
    }

    void initDefaultComments() {
        comments.add((Object)new Comment("webgoat", LocalDateTime.now().format(fmt), "Silly cat...."));
        comments.add((Object)new Comment("guest", LocalDateTime.now().format(fmt), "I think I will use this picture in one of my projects."));
        comments.add((Object)new Comment("guest", LocalDateTime.now().format(fmt), "Lol!! :-)."));
    }

    protected Comments getComments(WebGoatUser user) {
        Comments allComments = new Comments();
        Comments commentsByUser = (Comments)userComments.get(user);
        if (commentsByUser != null) {
            allComments.addAll((Collection)commentsByUser);
        }
        allComments.addAll((Collection)comments);
        allComments.sort();
        return allComments;
    }

    protected Comment parseXml(String xml, boolean securityEnabled) throws XMLStreamException, JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Comment.class});
        XMLInputFactory xif = XMLInputFactory.newInstance();
        if (securityEnabled) {
            xif.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            xif.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        XMLStreamReader xsr = xif.createXMLStreamReader(new StringReader(xml));
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        return (Comment)unmarshaller.unmarshal(xsr);
    }

    public void addComment(Comment comment, WebGoatUser user, boolean visibleForAllUsers) {
        comment.setDateTime(LocalDateTime.now().format(fmt));
        comment.setUser(user.getUsername());
        if (visibleForAllUsers) {
            comments.add((Object)comment);
        } else {
            Comments comments = userComments.getOrDefault(user.getUsername(), new Comments());
            comments.add((Object)comment);
            userComments.put(user, comments);
        }
    }

    public void reset(WebGoatUser user) {
        comments.clear();
        userComments.remove(user);
        this.initDefaultComments();
    }
}

