/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.webwolfintroduction;

import org.apache.commons.lang3.StringUtils;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class LandingAssignment
implements AssignmentEndpoint {
    private final String landingPageUrl;

    public LandingAssignment(@Value(value="${webwolf.landingpage.url}") String landingPageUrl) {
        this.landingPageUrl = landingPageUrl;
    }

    @PostMapping(value={"/WebWolf/landing"})
    @ResponseBody
    public AttackResult click(String uniqueCode, @CurrentUsername String username) {
        if (StringUtils.reverse((String)username).equals(uniqueCode)) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("webwolf.landing_wrong").build();
    }

    @GetMapping(value={"/WebWolf/landing/password-reset"})
    public ModelAndView openPasswordReset(@CurrentUsername String username) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("webwolfLandingPageUrl", (Object)this.landingPageUrl.replace("//landing", "/landing"));
        modelAndView.addObject("uniqueCode", (Object)StringUtils.reverse((String)username));
        modelAndView.setViewName("lessons/webwolfintroduction/templates/webwolfPasswordReset.html");
        return modelAndView;
    }
}

