/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.mitigation;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.sqlinjection.mitigation.SqlInjectionLesson10b;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"SqlStringInjectionHint-mitigation-10b-1", "SqlStringInjectionHint-mitigation-10b-2", "SqlStringInjectionHint-mitigation-10b-3", "SqlStringInjectionHint-mitigation-10b-4", "SqlStringInjectionHint-mitigation-10b-5"})
public class SqlInjectionLesson10b
implements AssignmentEndpoint {
    @PostMapping(value={"/SqlInjectionMitigations/attack10b"})
    @ResponseBody
    public AttackResult completed(@RequestParam String editor) {
        try {
            if (editor.isEmpty()) {
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.10b.no-code").build();
            }
            editor = editor.replaceAll("\\<.*?>", "");
            String regexSetsUpConnection = "(?=.*getConnection.*)";
            String regexUsesPreparedStatement = "(?=.*PreparedStatement.*)";
            String regexUsesPlaceholder = "(?=.*\\=\\?.*|.*\\=\\s\\?.*)";
            String regexUsesSetString = "(?=.*setString.*)";
            String regexUsesExecute = "(?=.*execute.*)";
            String regexUsesExecuteUpdate = "(?=.*executeUpdate.*)";
            String codeline = editor.replace("\n", "").replace("\r", "");
            boolean setsUpConnection = this.check_text(regexSetsUpConnection, codeline);
            boolean usesPreparedStatement = this.check_text(regexUsesPreparedStatement, codeline);
            boolean usesSetString = this.check_text(regexUsesSetString, codeline);
            boolean usesPlaceholder = this.check_text(regexUsesPlaceholder, codeline);
            boolean usesExecute = this.check_text(regexUsesExecute, codeline);
            boolean usesExecuteUpdate = this.check_text(regexUsesExecuteUpdate, codeline);
            boolean hasImportant = setsUpConnection && usesPreparedStatement && usesPlaceholder && usesSetString && (usesExecute || usesExecuteUpdate);
            List hasCompiled = this.compileFromString(editor);
            if (hasImportant && hasCompiled.size() < 1) {
                return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("sql-injection.10b.success").build();
            }
            if (hasCompiled.size() > 0) {
                Object errors = "";
                for (Diagnostic d : hasCompiled) {
                    errors = (String)errors + d.getMessage(null) + "<br>";
                }
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.10b.compiler-errors").output((String)errors).build();
            }
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.10b.failed").build();
        }
        catch (Exception e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(e.getMessage()).build();
        }
    }

    private List<Diagnostic> compileFromString(String s) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticsCollector = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnosticsCollector, null, null);
        SimpleJavaFileObject javaObjectFromString = this.getJavaFileContentsAsString(s);
        List<JavaFileObject> fileObjects = Arrays.asList(javaObjectFromString);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnosticsCollector, null, null, fileObjects);
        Boolean result = task.call();
        List<Diagnostic> diagnostics = diagnosticsCollector.getDiagnostics();
        return diagnostics;
    }

    private SimpleJavaFileObject getJavaFileContentsAsString(String s) {
        StringBuilder javaFileContents = new StringBuilder("import java.sql.*; public class TestClass { static String DBUSER; static String DBPW; static String DBURL; public static void main(String[] args) {" + s + "}}");
        JavaObjectFromString javaFileObject = null;
        try {
            javaFileObject = new JavaObjectFromString(this, "TestClass.java", javaFileContents.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return javaFileObject;
    }

    private boolean check_text(String regex, String text) {
        Pattern p = Pattern.compile(regex, 2);
        Matcher m = p.matcher(text);
        return m.find();
    }
}

