/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.mitigation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.lessons.sqlinjection.mitigation.Servers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SqlInjectionMitigations/servers"})
public class Servers {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Servers.class);
    private final LessonDataSource dataSource;

    public Servers(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @GetMapping(produces={"application/json"})
    @ResponseBody
    public List<Server> sort(@RequestParam String column) throws Exception {
        ArrayList<Server> servers = new ArrayList<Server>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("select id, hostname, ip, mac, status, description from SERVERS where status <> 'out of order' order by " + column);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                Server server = new Server(this, rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6));
                servers.add(server);
            }
        }
        return servers;
    }
}

