/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.introduction;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.sqlinjection.introduction.SqlInjectionLesson5a;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"SqlStringInjectionHint5b1", "SqlStringInjectionHint5b2", "SqlStringInjectionHint5b3", "SqlStringInjectionHint5b4"})
public class SqlInjectionLesson5b
implements AssignmentEndpoint {
    private final LessonDataSource dataSource;

    public SqlInjectionLesson5b(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostMapping(value={"/SqlInjection/assignment5b"})
    @ResponseBody
    public AttackResult completed(@RequestParam String userid, @RequestParam String login_count) throws IOException {
        return this.injectableQuery(login_count, userid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AttackResult injectableQuery(String login_count, String accountName) {
        String queryString = "SELECT * From user_data WHERE Login_Count = ? and userid= " + accountName;
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                block17: {
                    StringBuilder output;
                    PreparedStatement query = connection.prepareStatement(queryString, 1004, 1007);
                    int count = 0;
                    try {
                        count = Integer.parseInt(login_count);
                    }
                    catch (Exception e) {
                        AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).output("Could not parse: " + login_count + " to a number<br> Your query was: " + queryString.replace("?", login_count)).build();
                        if (connection == null) return attackResult;
                        connection.close();
                        return attackResult;
                    }
                    query.setInt(1, count);
                    try {
                        ResultSet results = query.executeQuery();
                        if (results == null || !results.first()) break block17;
                        ResultSetMetaData resultsMetaData = results.getMetaData();
                        output = new StringBuilder();
                        output.append(SqlInjectionLesson5a.writeTable((ResultSet)results, (ResultSetMetaData)resultsMetaData));
                        results.last();
                        if (results.getRow() >= 6) {
                            AttackResult attackResult = AttackResultBuilder.success((AssignmentEndpoint)this).feedback("sql-injection.5b.success").output("Your query was: " + queryString.replace("?", login_count)).feedbackArgs(new Object[]{output.toString()}).build();
                            return attackResult;
                        }
                    }
                    catch (SQLException sqle) {
                        AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).output(sqle.getMessage() + "<br> Your query was: " + queryString.replace("?", login_count)).build();
                        return attackResult;
                    }
                    AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).output(output.toString() + "<br> Your query was: " + queryString.replace("?", login_count)).build();
                    return attackResult;
                }
                AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.5b.no.results").output("Your query was: " + queryString.replace("?", login_count)).build();
                return attackResult;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (Exception e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(this.getClass().getName() + " : " + e.getMessage() + "<br> Your query was: " + queryString.replace("?", login_count)).build();
        }
    }
}

