/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.introduction;

import jakarta.annotation.PostConstruct;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"SqlStringInjectionHint5-1", "SqlStringInjectionHint5-2", "SqlStringInjectionHint5-3", "SqlStringInjectionHint5-4"})
public class SqlInjectionLesson5
implements AssignmentEndpoint {
    private final LessonDataSource dataSource;

    public SqlInjectionLesson5(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostConstruct
    public void createUser() {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("CREATE USER unauthorized_user PASSWORD test");){
            statement.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @PostMapping(value={"/SqlInjection/attack5"})
    @ResponseBody
    public AttackResult completed(String query) {
        this.createUser();
        return this.injectableQuery(query);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected AttackResult injectableQuery(String query) {
        try (Connection connection = this.dataSource.getConnection();){
            AttackResult attackResult;
            block18: {
                Statement statement;
                block16: {
                    AttackResult attackResult2;
                    block17: {
                        statement = connection.createStatement(1004, 1008);
                        try {
                            statement.executeQuery(query);
                            if (!this.checkSolution(connection)) break block16;
                            attackResult2 = AttackResultBuilder.success((AssignmentEndpoint)this).build();
                            if (statement == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        statement.close();
                    }
                    return attackResult2;
                }
                attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).output("Your query was: " + query).build();
                if (statement == null) break block18;
                statement.close();
            }
            return attackResult;
        }
        catch (Exception e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(this.getClass().getName() + " : " + e.getMessage() + "<br> Your query was: " + query).build();
        }
    }

    private boolean checkSolution(Connection connection) {
        try {
            PreparedStatement stmt = connection.prepareStatement("SELECT * FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES WHERE TABLE_NAME = ? AND GRANTEE = ?");
            stmt.setString(1, "GRANT_RIGHTS");
            stmt.setString(2, "UNAUTHORIZED_USER");
            ResultSet resultSet = stmt.executeQuery();
            return resultSet.next();
        }
        catch (SQLException throwables) {
            return false;
        }
    }
}

