/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.introduction;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.sqlinjection.introduction.SqlInjectionLesson8;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"SqlStringInjectionHint2-1", "SqlStringInjectionHint2-2", "SqlStringInjectionHint2-3", "SqlStringInjectionHint2-4"})
public class SqlInjectionLesson2
implements AssignmentEndpoint {
    private final LessonDataSource dataSource;

    public SqlInjectionLesson2(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostMapping(value={"/SqlInjection/attack2"})
    @ResponseBody
    public AttackResult completed(@RequestParam String query) {
        return this.injectableQuery(query);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AttackResult injectableQuery(String query) {
        try (Connection connection = this.dataSource.getConnection();){
            Statement statement = connection.createStatement(1004, 1007);
            ResultSet results = statement.executeQuery(query);
            StringBuilder output = new StringBuilder();
            results.first();
            if (results.getString("department").equals("Marketing")) {
                output.append("<span class='feedback-positive'>" + query + "</span>");
                output.append(SqlInjectionLesson8.generateTable((ResultSet)results));
                AttackResult attackResult2 = AttackResultBuilder.success((AssignmentEndpoint)this).feedback("sql-injection.2.success").output(output.toString()).build();
                return attackResult2;
            }
            AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.2.failed").output(output.toString()).build();
            return attackResult;
        }
        catch (SQLException sqle) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("sql-injection.2.failed").output(sqle.getMessage()).build();
        }
    }
}

