/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.advanced;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SqlInjectionChallengeLogin
implements AssignmentEndpoint {
    private final LessonDataSource dataSource;

    public SqlInjectionChallengeLogin(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostMapping(value={"/SqlInjectionAdvanced/login"})
    @ResponseBody
    public AttackResult login(@RequestParam(value="username_login") String username, @RequestParam(value="password_login") String password) throws Exception {
        try (Connection connection = this.dataSource.getConnection();){
            PreparedStatement statement = connection.prepareStatement("select password from sql_challenge_users where userid = ? and password = ?");
            statement.setString(1, username);
            statement.setString(2, password);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                AttackResult attackResult = "tom".equals(username) ? AttackResultBuilder.success((AssignmentEndpoint)this).build() : AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("ResultsButNotTom").build();
                return attackResult;
            }
            AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("NoResultsMatched").build();
            return attackResult;
        }
    }
}

