/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.sqlinjection.advanced;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import lombok.Generated;
import org.owasp.webgoat.container.LessonDataSource;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"SqlInjectionChallenge1", "SqlInjectionChallenge2", "SqlInjectionChallenge3", "SqlInjectionChallenge4", "SqlInjectionChallenge5", "SqlInjectionChallenge6", "SqlInjectionChallenge7"})
public class SqlInjectionChallenge
implements AssignmentEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlInjectionChallenge.class);
    private final LessonDataSource dataSource;

    public SqlInjectionChallenge(LessonDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PutMapping(value={"/SqlInjectionAdvanced/register"})
    @ResponseBody
    public AttackResult registerNewUser(@RequestParam(value="username_reg") String username, @RequestParam(value="email_reg") String email, @RequestParam(value="password_reg") String password) {
        AttackResult attackResult = this.checkArguments(username, email, password);
        if (attackResult == null) {
            try (Connection connection = this.dataSource.getConnection();){
                String checkUserQuery = "select userid from sql_challenge_users where userid = '" + username + "'";
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(checkUserQuery);
                if (resultSet.next()) {
                    attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("user.exists").feedbackArgs(new Object[]{username}).build();
                } else {
                    PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO sql_challenge_users VALUES (?, ?, ?)");
                    preparedStatement.setString(1, username);
                    preparedStatement.setString(2, email);
                    preparedStatement.setString(3, password);
                    preparedStatement.execute();
                    attackResult = AttackResultBuilder.informationMessage((AssignmentEndpoint)this).feedback("user.created").feedbackArgs(new Object[]{username}).build();
                }
            }
            catch (SQLException e) {
                attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).output("Something went wrong").build();
            }
        }
        return attackResult;
    }

    private AttackResult checkArguments(String username, String email, String password) {
        if (StringUtils.isEmpty((Object)username) || StringUtils.isEmpty((Object)email) || StringUtils.isEmpty((Object)password)) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("input.invalid").build();
        }
        if (username.length() > 250 || email.length() > 30 || password.length() > 30) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("input.invalid").build();
        }
        return null;
    }
}

