/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.pathtraversal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.FileSystemUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class ProfileUploadBase
implements AssignmentEndpoint {
    private final String webGoatHomeDirectory;

    public ProfileUploadBase(String webGoatHomeDirectory) {
        this.webGoatHomeDirectory = webGoatHomeDirectory;
    }

    protected AttackResult execute(MultipartFile file, String fullName, String username) {
        if (file.isEmpty()) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("path-traversal-profile-empty-file").build();
        }
        if (StringUtils.isEmpty((Object)fullName)) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("path-traversal-profile-empty-name").build();
        }
        File uploadDirectory = this.cleanupAndCreateDirectoryForUser(username);
        try {
            File uploadedFile = new File(uploadDirectory, fullName);
            uploadedFile.createNewFile();
            FileCopyUtils.copy((byte[])file.getBytes(), (File)uploadedFile);
            if (this.attemptWasMade(uploadDirectory, uploadedFile)) {
                return this.solvedIt(uploadedFile);
            }
            return AttackResultBuilder.informationMessage((AssignmentEndpoint)this).feedback("path-traversal-profile-updated").feedbackArgs(new Object[]{uploadedFile.getAbsoluteFile()}).build();
        }
        catch (IOException e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output(e.getMessage()).build();
        }
    }

    protected File cleanupAndCreateDirectoryForUser(String username) {
        File uploadDirectory = new File(this.webGoatHomeDirectory, "/PathTraversal/" + username);
        if (uploadDirectory.exists()) {
            FileSystemUtils.deleteRecursively((File)uploadDirectory);
        }
        Files.createDirectories(uploadDirectory.toPath(), new FileAttribute[0]);
        return uploadDirectory;
    }

    private boolean attemptWasMade(File expectedUploadDirectory, File uploadedFile) throws IOException {
        return !expectedUploadDirectory.getCanonicalPath().equals(uploadedFile.getParentFile().getCanonicalPath());
    }

    private AttackResult solvedIt(File uploadedFile) throws IOException {
        if (uploadedFile.getCanonicalFile().getParentFile().getName().endsWith("PathTraversal")) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).attemptWasMade().feedback("path-traversal-profile-attempt").feedbackArgs(new Object[]{uploadedFile.getCanonicalPath()}).build();
    }

    public ResponseEntity<?> getProfilePicture(@CurrentUsername String username) {
        return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"image/jpeg")).body((Object)this.getProfilePictureAsBase64(username));
    }

    protected byte[] getProfilePictureAsBase64(String username) {
        File profilePictureDirectory = new File(this.webGoatHomeDirectory, "/PathTraversal/" + username);
        File[] profileDirectoryFiles = profilePictureDirectory.listFiles();
        if (profileDirectoryFiles != null && profileDirectoryFiles.length > 0) {
            return Arrays.stream(profileDirectoryFiles).filter(file -> FilenameUtils.isExtension((String)file.getName(), List.of("jpg", "png"))).findFirst().map(file -> {
                byte[] byArray;
                FileInputStream inputStream = new FileInputStream(profileDirectoryFiles[0]);
                try {
                    byArray = Base64.getEncoder().encode(FileCopyUtils.copyToByteArray((InputStream)inputStream));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return this.defaultImage();
                    }
                }
                inputStream.close();
                return byArray;
            }).orElse(this.defaultImage());
        }
        return this.defaultImage();
    }

    protected byte[] defaultImage() {
        InputStream inputStream = this.getClass().getResourceAsStream("/images/account.png");
        return Base64.getEncoder().encode(FileCopyUtils.copyToByteArray((InputStream)inputStream));
    }

    @Generated
    public String getWebGoatHomeDirectory() {
        return this.webGoatHomeDirectory;
    }
}

