/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.passwordreset;

import java.time.LocalDateTime;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.passwordreset.PasswordResetEmail;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@RestController
public class SimpleMailAssignment
implements AssignmentEndpoint {
    private final String webWolfURL;
    private RestTemplate restTemplate;

    public SimpleMailAssignment(RestTemplate restTemplate, @Value(value="${webwolf.mail.url}") String webWolfURL) {
        this.restTemplate = restTemplate;
        this.webWolfURL = webWolfURL;
    }

    @PostMapping(path={"/PasswordReset/simple-mail"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public AttackResult login(@RequestParam String email, @RequestParam String password, @CurrentUsername String webGoatUsername) {
        String emailAddress = Optional.ofNullable(email).orElse("unknown@webgoat.org");
        String username = this.extractUsername(emailAddress);
        if (username.equals(webGoatUsername) && StringUtils.reverse((String)username).equals(password)) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedbackArgs(new Object[]{"password-reset-simple.password_incorrect"}).build();
    }

    @PostMapping(consumes={"application/x-www-form-urlencoded"}, value={"/PasswordReset/simple-mail/reset"})
    @ResponseBody
    public AttackResult resetPassword(@RequestParam String emailReset, @CurrentUsername String username) {
        String email = Optional.ofNullable(emailReset).orElse("unknown@webgoat.org");
        return this.sendEmail(this.extractUsername(email), email, username);
    }

    private String extractUsername(String email) {
        int index = email.indexOf("@");
        return email.substring(0, index == -1 ? email.length() : index);
    }

    private AttackResult sendEmail(String username, String email, String webGoatUsername) {
        if (username.equals(webGoatUsername)) {
            PasswordResetEmail mailEvent = PasswordResetEmail.builder().recipient(username).title("Simple e-mail assignment").time(LocalDateTime.now()).contents("Thanks for resetting your password, your new password is: " + StringUtils.reverse((String)username)).sender("webgoat@owasp.org").build();
            try {
                this.restTemplate.postForEntity(this.webWolfURL, (Object)mailEvent, Object.class, new Object[0]);
            }
            catch (RestClientException e) {
                return AttackResultBuilder.informationMessage((AssignmentEndpoint)this).feedback("password-reset-simple.email_failed").output(e.getMessage()).build();
            }
            return AttackResultBuilder.informationMessage((AssignmentEndpoint)this).feedback("password-reset-simple.email_send").feedbackArgs(new Object[]{email}).build();
        }
        return AttackResultBuilder.informationMessage((AssignmentEndpoint)this).feedback("password-reset-simple.email_mismatch").feedbackArgs(new Object[]{username}).build();
    }
}

