/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.passwordreset;

import jakarta.servlet.http.HttpServletRequest;
import java.util.UUID;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.passwordreset.PasswordResetEmail;
import org.owasp.webgoat.lessons.passwordreset.ResetLinkAssignment;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class ResetLinkAssignmentForgotPassword
implements AssignmentEndpoint {
    private final RestTemplate restTemplate;
    private final String webWolfHost;
    private final String webWolfPort;
    private final String webWolfURL;
    private final String webWolfMailURL;

    public ResetLinkAssignmentForgotPassword(RestTemplate restTemplate, @Value(value="${webwolf.host}") String webWolfHost, @Value(value="${webwolf.port}") String webWolfPort, @Value(value="${webwolf.url}") String webWolfURL, @Value(value="${webwolf.mail.url}") String webWolfMailURL) {
        this.restTemplate = restTemplate;
        this.webWolfHost = webWolfHost;
        this.webWolfPort = webWolfPort;
        this.webWolfURL = webWolfURL;
        this.webWolfMailURL = webWolfMailURL;
    }

    @PostMapping(value={"/PasswordReset/ForgotPassword/create-password-reset-link"})
    @ResponseBody
    public AttackResult sendPasswordResetLink(@RequestParam String email, HttpServletRequest request, @CurrentUsername String username) {
        String resetLink = UUID.randomUUID().toString();
        ResetLinkAssignment.resetLinks.add(resetLink);
        String host = request.getHeader("Host");
        if ("tom@webgoat-cloud.org".equals(email) && host.contains(this.webWolfPort) && host.contains(this.webWolfHost)) {
            ResetLinkAssignment.userToTomResetLink.put(username, resetLink);
            this.fakeClickingLinkEmail(this.webWolfURL, resetLink);
        } else {
            try {
                this.sendMailToUser(email, host, resetLink);
            }
            catch (Exception e) {
                return AttackResultBuilder.failed((AssignmentEndpoint)this).output("E-mail can't be send. please try again.").build();
            }
        }
        return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("email.send").feedbackArgs(new Object[]{email}).build();
    }

    private void sendMailToUser(String email, String host, String resetLink) {
        int index = email.indexOf("@");
        String username = email.substring(0, index == -1 ? email.length() : index);
        PasswordResetEmail mail = PasswordResetEmail.builder().title("Your password reset link").contents(String.format("Hi, you requested a password reset link, please use this <a target='_blank'\n href='http://%s/WebGoat/PasswordReset/reset/reset-password/%s'>link</a> to reset your\n password.\n\nIf you did not request this password change you can ignore this message.\nIf you have any comments or questions, please do not hesitate to reach us at\n support@webgoat-cloud.org\n\nKind regards,\nTeam WebGoat\n", host, resetLink)).sender("password-reset@webgoat-cloud.net").recipient(username).build();
        this.restTemplate.postForEntity(this.webWolfMailURL, (Object)mail, Object.class, new Object[0]);
    }

    private void fakeClickingLinkEmail(String webWolfURL, String resetLink) {
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
            new RestTemplate().exchange(String.format("%s/PasswordReset/reset/reset-password/%s", webWolfURL, resetLink), HttpMethod.GET, httpEntity, Void.class, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

