/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.passwordreset;

import java.util.HashMap;
import java.util.Map;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class QuestionsAssignment
implements AssignmentEndpoint {
    private static final Map<String, String> COLORS = new HashMap();

    @PostMapping(path={"/PasswordReset/questions"}, consumes={"application/x-www-form-urlencoded"})
    @ResponseBody
    public AttackResult passwordReset(@RequestParam Map<String, Object> json) {
        String securityQuestion = (String)json.getOrDefault("securityQuestion", "");
        String username = (String)json.getOrDefault("username", "");
        if ("webgoat".equalsIgnoreCase(username.toLowerCase())) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("password-questions-wrong-user").build();
        }
        String validAnswer = (String)COLORS.get(username.toLowerCase());
        if (validAnswer == null) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("password-questions-unknown-user").feedbackArgs(new Object[]{username}).build();
        }
        if (validAnswer.equals(securityQuestion)) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).build();
    }

    static {
        COLORS.put("admin", "green");
        COLORS.put("jerry", "orange");
        COLORS.put("tom", "purple");
        COLORS.put("larry", "yellow");
        COLORS.put("webgoat", "red");
    }
}

