/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.missingac;

import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.missingac.DisplayUser;
import org.owasp.webgoat.lessons.missingac.MissingAccessControlUserRepository;
import org.owasp.webgoat.lessons.missingac.User;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"access-control.hash.hint1", "access-control.hash.hint2", "access-control.hash.hint3", "access-control.hash.hint4", "access-control.hash.hint5"})
public class MissingFunctionACYourHash
implements AssignmentEndpoint {
    private final MissingAccessControlUserRepository userRepository;

    public MissingFunctionACYourHash(MissingAccessControlUserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @PostMapping(path={"/access-control/user-hash"}, produces={"application/json"})
    @ResponseBody
    public AttackResult simple(String userHash) {
        User user = this.userRepository.findByUsername("Jerry");
        DisplayUser displayUser = new DisplayUser(user, "DeliberatelyInsecure1234");
        if (userHash.equals(displayUser.getUserHash())) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("access-control.hash.success").build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).build();
    }
}

