/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.missingac;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.lessons.missingac.DisplayUser;
import org.owasp.webgoat.lessons.missingac.MissingAccessControlUserRepository;
import org.owasp.webgoat.lessons.missingac.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MissingFunctionACUsers {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MissingFunctionACUsers.class);
    private final MissingAccessControlUserRepository userRepository;

    @GetMapping(path={"access-control/users"})
    public ModelAndView listUsers() {
        ModelAndView model = new ModelAndView();
        model.setViewName("list_users");
        List allUsers = this.userRepository.findAllUsers();
        model.addObject("numUsers", (Object)allUsers.size());
        ArrayList<DisplayUser> displayUsers = new ArrayList<DisplayUser>();
        for (User user : allUsers) {
            displayUsers.add(new DisplayUser(user, "DeliberatelyInsecure1234"));
        }
        model.addObject("allUsers", displayUsers);
        return model;
    }

    @GetMapping(path={"access-control/users"}, consumes={"application/json"})
    @ResponseBody
    public ResponseEntity<List<DisplayUser>> usersService() {
        return ResponseEntity.ok(this.userRepository.findAllUsers().stream().map(user -> new DisplayUser(user, "DeliberatelyInsecure1234")).collect(Collectors.toList()));
    }

    @GetMapping(path={"access-control/users-admin-fix"}, consumes={"application/json"})
    @ResponseBody
    public ResponseEntity<List<DisplayUser>> usersFixed(@CurrentUsername String username) {
        User currentUser = this.userRepository.findByUsername(username);
        if (currentUser != null && currentUser.isAdmin()) {
            return ResponseEntity.ok(this.userRepository.findAllUsers().stream().map(user -> new DisplayUser(user, "DeliberatelyInsecure1235")).collect(Collectors.toList()));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
    }

    @PostMapping(path={"access-control/users", "access-control/users-admin-fix"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public User addUser(@RequestBody User newUser) {
        try {
            this.userRepository.save(newUser);
            return newUser;
        }
        catch (Exception ex) {
            log.error("Error creating new User", (Throwable)ex);
            return null;
        }
    }

    @Generated
    public MissingFunctionACUsers(MissingAccessControlUserRepository userRepository) {
        this.userRepository = userRepository;
    }
}

