/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.jwt;

import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JWTQuiz
implements AssignmentEndpoint {
    private final String[] solutions = new String[]{"Solution 1", "Solution 2"};
    private final boolean[] guesses = new boolean[this.solutions.length];

    @PostMapping(value={"/JWT/quiz"})
    @ResponseBody
    public AttackResult completed(@RequestParam String[] question_0_solution, @RequestParam String[] question_1_solution) {
        int correctAnswers = 0;
        String[] givenAnswers = new String[]{question_0_solution[0], question_1_solution[0]};
        for (int i = 0; i < this.solutions.length; ++i) {
            if (givenAnswers[i].contains(this.solutions[i])) {
                ++correctAnswers;
                this.guesses[i] = true;
                continue;
            }
            this.guesses[i] = false;
        }
        if (correctAnswers == this.solutions.length) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).build();
        }
        return AttackResultBuilder.failed((AssignmentEndpoint)this).build();
    }

    @GetMapping(value={"/JWT/quiz"})
    @ResponseBody
    public boolean[] getResults() {
        return this.guesses;
    }
}

