/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.idor;

import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.container.session.LessonSession;
import org.owasp.webgoat.lessons.idor.UserProfile;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"idor.hints.ownProfileAltUrl1", "idor.hints.ownProfileAltUrl2", "idor.hints.ownProfileAltUrl3"})
public class IDORViewOwnProfileAltUrl
implements AssignmentEndpoint {
    private final LessonSession userSessionData;

    public IDORViewOwnProfileAltUrl(LessonSession userSessionData) {
        this.userSessionData = userSessionData;
    }

    @PostMapping(value={"/IDOR/profile/alt-path"})
    @ResponseBody
    public AttackResult completed(@RequestParam String url) {
        try {
            if (this.userSessionData.getValue("idor-authenticated-as").equals("tom")) {
                String authUserId = (String)this.userSessionData.getValue("idor-authenticated-user-id");
                String[] urlParts = url.split("/");
                if (urlParts[0].equals("WebGoat") && urlParts[1].equals("IDOR") && urlParts[2].equals("profile") && urlParts[3].equals(authUserId)) {
                    UserProfile userProfile = new UserProfile(authUserId);
                    return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("idor.view.own.profile.success").output(userProfile.profileToMap().toString()).build();
                }
                return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("idor.view.own.profile.failure1").build();
            }
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("idor.view.own.profile.failure2").build();
        }
        catch (Exception ex) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).output("an error occurred with your request").build();
        }
    }
}

