/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.idor;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.owasp.webgoat.container.session.LessonSession;
import org.owasp.webgoat.lessons.idor.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IDORViewOwnProfile {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IDORViewOwnProfile.class);
    private final LessonSession userSessionData;

    public IDORViewOwnProfile(LessonSession userSessionData) {
        this.userSessionData = userSessionData;
    }

    @GetMapping(path={"/IDOR/own", "/IDOR/profile"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> invoke() {
        HashMap<String, Object> details = new HashMap<String, Object>();
        try {
            if (this.userSessionData.getValue("idor-authenticated-as").equals("tom")) {
                String authUserId = (String)this.userSessionData.getValue("idor-authenticated-user-id");
                UserProfile userProfile = new UserProfile(authUserId);
                details.put("userId", userProfile.getUserId());
                details.put("name", userProfile.getName());
                details.put("color", userProfile.getColor());
                details.put("size", userProfile.getSize());
                details.put("role", userProfile.getRole());
            } else {
                details.put("error", "You do not have privileges to view the profile. Authenticate as tom first please.");
            }
        }
        catch (Exception ex) {
            log.error("something went wrong: {}", (Object)ex.getMessage());
        }
        return details;
    }
}

