/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.hijacksession.cas;

import java.time.Instant;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoublePredicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.owasp.webgoat.lessons.hijacksession.cas.Authentication;
import org.owasp.webgoat.lessons.hijacksession.cas.AuthenticationProvider;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.ApplicationScope;

@ApplicationScope
@Component
public class HijackSessionAuthenticationProvider
implements AuthenticationProvider<Authentication> {
    private Queue<String> sessions = new LinkedList();
    private static long id = new Random().nextLong() & Long.MAX_VALUE;
    protected static final int MAX_SESSIONS = 50;
    private static final DoublePredicate PROBABILITY_DOUBLE_PREDICATE = pr -> pr < 0.75;
    private static final Supplier<String> GENERATE_SESSION_ID = () -> ++id + "-" + Instant.now().toEpochMilli();
    public static final Supplier<Authentication> AUTHENTICATION_SUPPLIER = () -> Authentication.builder().id((String)GENERATE_SESSION_ID.get()).build();

    public Authentication authenticate(Authentication authentication) {
        if (authentication == null) {
            return (Authentication)AUTHENTICATION_SUPPLIER.get();
        }
        if (StringUtils.isNotEmpty((CharSequence)authentication.getId()) && this.sessions.contains(authentication.getId())) {
            authentication.setAuthenticated(true);
            return authentication;
        }
        if (StringUtils.isEmpty((CharSequence)authentication.getId())) {
            authentication.setId((String)GENERATE_SESSION_ID.get());
        }
        this.authorizedUserAutoLogin();
        return authentication;
    }

    protected void authorizedUserAutoLogin() {
        if (!PROBABILITY_DOUBLE_PREDICATE.test(ThreadLocalRandom.current().nextDouble())) {
            Authentication authentication = (Authentication)AUTHENTICATION_SUPPLIER.get();
            authentication.setAuthenticated(true);
            this.addSession(authentication.getId());
        }
    }

    protected boolean addSession(String sessionId) {
        if (this.sessions.size() >= 50) {
            this.sessions.remove();
        }
        return this.sessions.add(sessionId);
    }

    protected int getSessionsSize() {
        return this.sessions.size();
    }
}

