/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.deserialization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.util.Base64;
import org.dummy.insecure.framework.VulnerableTaskHolder;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"insecure-deserialization.hints.1", "insecure-deserialization.hints.2", "insecure-deserialization.hints.3"})
public class InsecureDeserializationTask
implements AssignmentEndpoint {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/InsecureDeserialization/task"})
    @ResponseBody
    public AttackResult completed(@RequestParam String token) throws IOException {
        long after;
        long before;
        String b64token = token.replace('-', '+').replace('_', '/');
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(b64token)));){
            before = System.currentTimeMillis();
            Object o = ois.readObject();
            if (!(o instanceof VulnerableTaskHolder)) {
                if (o instanceof String) {
                    AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("insecure-deserialization.stringobject").build();
                    return attackResult;
                }
                AttackResult attackResult = AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("insecure-deserialization.wrongobject").build();
                return attackResult;
            }
            after = System.currentTimeMillis();
        }
        catch (InvalidClassException e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("insecure-deserialization.invalidversion").build();
        }
        catch (IllegalArgumentException e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("insecure-deserialization.expired").build();
        }
        catch (Exception e) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("insecure-deserialization.invalidversion").build();
        }
        int delay = (int)(after - before);
        if (delay > 7000) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).build();
        }
        if (delay >= 3000) return AttackResultBuilder.success((AssignmentEndpoint)this).build();
        return AttackResultBuilder.failed((AssignmentEndpoint)this).build();
    }
}

