/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.csrf;

import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.csrf.Review;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"csrf-review-hint1", "csrf-review-hint2", "csrf-review-hint3"})
public class ForgedReviews
implements AssignmentEndpoint {
    private static DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd, HH:mm:ss");
    private static final Map<String, List<Review>> userReviews = new HashMap();
    private static final List<Review> REVIEWS = new ArrayList();
    private static final String weakAntiCSRF = "2aa14227b9a13d0bede0388a7fba9aa9";

    @GetMapping(path={"/csrf/review"}, produces={"application/json"}, consumes={"*/*"})
    @ResponseBody
    public Collection<Review> retrieveReviews(@CurrentUsername String username) {
        ArrayList allReviews = Lists.newArrayList();
        Collection newReviews = (Collection)userReviews.get(username);
        if (newReviews != null) {
            allReviews.addAll(newReviews);
        }
        allReviews.addAll(REVIEWS);
        return allReviews;
    }

    @PostMapping(value={"/csrf/review"})
    @ResponseBody
    public AttackResult createNewReview(String reviewText, Integer stars, String validateReq, HttpServletRequest request, @CurrentUsername String username) {
        String host = request.getHeader("host") == null ? "NULL" : request.getHeader("host");
        String referer = request.getHeader("referer") == null ? "NULL" : request.getHeader("referer");
        String[] refererArr = referer.split("/");
        Review review = new Review();
        review.setText(reviewText);
        review.setDateTime(LocalDateTime.now().format(fmt));
        review.setUser(username);
        review.setStars(stars);
        List reviews = userReviews.getOrDefault(username, new ArrayList());
        reviews.add(review);
        userReviews.put(username, reviews);
        if (validateReq == null || !validateReq.equals(weakAntiCSRF)) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("csrf-you-forgot-something").build();
        }
        if (referer != "NULL" && refererArr[2].equals(host)) {
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("csrf-same-host").build();
        }
        return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("csrf-review.success").build();
    }

    static {
        REVIEWS.add(new Review("secUriTy", LocalDateTime.now().format(fmt), "This is like swiss cheese", Integer.valueOf(0)));
        REVIEWS.add(new Review("webgoat", LocalDateTime.now().format(fmt), "It works, sorta", Integer.valueOf(2)));
        REVIEWS.add(new Review("guest", LocalDateTime.now().format(fmt), "Best, App, Ever", Integer.valueOf(5)));
        REVIEWS.add(new Review("guest", LocalDateTime.now().format(fmt), "This app is so insecure, I didn't even post this review, can you pull that off too?", Integer.valueOf(1)));
    }
}

