/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.cryptography;

import jakarta.servlet.http.HttpServletRequest;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.assignments.AttackResultBuilder;
import org.owasp.webgoat.lessons.cryptography.CryptoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@AssignmentHints(value={"crypto-signing.hints.1", "crypto-signing.hints.2", "crypto-signing.hints.3", "crypto-signing.hints.4"})
public class SigningAssignment
implements AssignmentEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigningAssignment.class);

    @RequestMapping(path={"/crypto/signing/getprivate"}, produces={"text/html"})
    @ResponseBody
    public String getPrivateKey(HttpServletRequest request) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        String privateKey = (String)request.getSession().getAttribute("privateKeyString");
        if (privateKey == null) {
            KeyPair keyPair = CryptoUtil.generateKeyPair();
            privateKey = CryptoUtil.getPrivateKeyInPEM((KeyPair)keyPair);
            request.getSession().setAttribute("privateKeyString", (Object)privateKey);
            request.getSession().setAttribute("keyPair", (Object)keyPair);
        }
        return privateKey;
    }

    @PostMapping(value={"/crypto/signing/verify"})
    @ResponseBody
    public AttackResult completed(HttpServletRequest request, @RequestParam String modulus, @RequestParam String signature) {
        String tempModulus = modulus;
        KeyPair keyPair = (KeyPair)request.getSession().getAttribute("keyPair");
        RSAPublicKey rsaPubKey = (RSAPublicKey)keyPair.getPublic();
        if (tempModulus.length() == 512) {
            tempModulus = "00".concat(tempModulus);
        }
        if (!DatatypeConverter.printHexBinary((byte[])rsaPubKey.getModulus().toByteArray()).equals(tempModulus.toUpperCase())) {
            log.warn("modulus {} incorrect", (Object)modulus);
            return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("crypto-signing.modulusnotok").build();
        }
        if (CryptoUtil.verifyMessage((String)modulus, (String)signature, (PublicKey)keyPair.getPublic())) {
            return AttackResultBuilder.success((AssignmentEndpoint)this).feedback("crypto-signing.success").build();
        }
        log.warn("signature incorrect");
        return AttackResultBuilder.failed((AssignmentEndpoint)this).feedback("crypto-signing.notok").build();
    }
}

