/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.challenges.challenge8;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.lessons.challenges.Flags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class Assignment8
implements AssignmentEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Assignment8.class);
    private static final Map<Integer, Integer> votes = new HashMap();
    private final Flags flags;

    @GetMapping(value={"/challenge/8/vote/{stars}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> vote(@PathVariable(value="stars") int nrOfStars, HttpServletRequest request) {
        String msg = "";
        if (request.getMethod().equals("GET")) {
            Map<String, String> json = Map.of("error", true, "message", "Sorry but you need to login first in order to vote");
            return ResponseEntity.status((int)200).body(json);
        }
        Integer allVotesForStar = votes.getOrDefault(nrOfStars, 0);
        votes.put(nrOfStars, allVotesForStar + 1);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("X-FlagController", new String[]{"Thanks for voting, your flag is: " + String.valueOf(this.flags.getFlag(8))})).build();
    }

    @GetMapping(value={"/challenge/8/votes/"})
    public ResponseEntity<?> getVotes() {
        return ResponseEntity.ok(votes.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> (Integer)e.getValue())));
    }

    @GetMapping(value={"/challenge/8/votes/average"})
    public ResponseEntity<Map<String, Integer>> average() {
        int totalNumberOfVotes = votes.values().stream().mapToInt(i -> i).sum();
        int categories = votes.entrySet().stream().mapToInt(e -> (Integer)e.getKey() * (Integer)e.getValue()).reduce(0, (a, b) -> a + b);
        Map<String, Integer> json = Map.of("average", (int)Math.ceil((double)categories / (double)totalNumberOfVotes));
        return ResponseEntity.ok(json);
    }

    @GetMapping(value={"/challenge/8/notUsed"})
    public AttackResult notUsed() {
        throw new IllegalStateException("Should never be called, challenge specific method");
    }

    @Generated
    public Assignment8(Flags flags) {
        this.flags = flags;
    }

    static {
        votes.put(1, 400);
        votes.put(2, 120);
        votes.put(3, 140);
        votes.put(4, 150);
        votes.put(5, 300);
    }
}

