/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.lessons.challenges.challenge7;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.owasp.webgoat.lessons.challenges.challenge7.MD5;

/*
 * Exception performing whole class analysis ignored.
 */
public class MD5 {
    private MD5State workingState = new MD5State(this);
    private MD5State finalState = new MD5State(this);
    private int[] decodeBuffer = new int[16];
    private static final byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public MD5() {
        this.reset();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Please specify a file.");
        } else {
            for (String element : args) {
                try {
                    System.out.println(MD5.getHashString((File)new File(element)) + " " + element);
                }
                catch (IOException x) {
                    System.err.println(x.getMessage());
                }
            }
        }
    }

    public byte[] getHash() {
        if (!this.finalState.valid) {
            this.finalState.copy(this.workingState);
            long bitCount = this.finalState.bitCount;
            int leftOver = (int)(bitCount >>> 3 & 0x3FL);
            int padlen = leftOver < 56 ? 56 - leftOver : 120 - leftOver;
            this.update(this.finalState, padding, 0, padlen);
            this.update(this.finalState, MD5.encode((long)bitCount), 0, 8);
            this.finalState.valid = true;
        }
        return MD5.encode((int[])this.finalState.state, (int)16);
    }

    public String getHashString() {
        return MD5.toHex((byte[])this.getHash());
    }

    public static byte[] getHash(byte[] b) {
        MD5 md5 = new MD5();
        md5.update(b);
        return md5.getHash();
    }

    public static String getHashString(byte[] b) {
        MD5 md5 = new MD5();
        md5.update(b);
        return md5.getHashString();
    }

    public static byte[] getHash(InputStream in) throws IOException {
        int read;
        MD5 md5 = new MD5();
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            md5.update(buffer, read);
        }
        return md5.getHash();
    }

    public static String getHashString(InputStream in) throws IOException {
        int read;
        MD5 md5 = new MD5();
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            md5.update(buffer, read);
        }
        return md5.getHashString();
    }

    public static byte[] getHash(File f) throws IOException {
        byte[] hash = null;
        try (FileInputStream is = new FileInputStream(f);){
            hash = MD5.getHash((InputStream)is);
        }
        return hash;
    }

    public static String getHashString(File f) throws IOException {
        String hash = null;
        try (FileInputStream is = new FileInputStream(f);){
            hash = MD5.getHashString((InputStream)is);
        }
        return hash;
    }

    public static byte[] getHash(String s) {
        MD5 md5 = new MD5();
        md5.update(s);
        return md5.getHash();
    }

    public static String getHashString(String s) {
        MD5 md5 = new MD5();
        md5.update(s);
        return md5.getHashString();
    }

    public static byte[] getHash(String s, String enc) throws UnsupportedEncodingException {
        MD5 md5 = new MD5();
        md5.update(s, enc);
        return md5.getHash();
    }

    public static String getHashString(String s, String enc) throws UnsupportedEncodingException {
        MD5 md5 = new MD5();
        md5.update(s, enc);
        return md5.getHashString();
    }

    public void reset() {
        this.workingState.reset();
        this.finalState.valid = false;
    }

    public String toString() {
        return this.getHashString();
    }

    private void update(MD5State state, byte[] buffer, int offset, int length) {
        this.finalState.valid = false;
        if (length + offset > buffer.length) {
            length = buffer.length - offset;
        }
        int index = (int)(state.bitCount >>> 3) & 0x3F;
        state.bitCount += (long)(length << 3);
        int partlen = 64 - index;
        int i = 0;
        if (length >= partlen) {
            System.arraycopy(buffer, offset, state.buffer, index, partlen);
            MD5.transform((MD5State)state, (int[])this.decode(state.buffer, 64, 0));
            i = partlen;
            while (i + 63 < length) {
                MD5.transform((MD5State)state, (int[])this.decode(buffer, 64, i));
                i += 64;
            }
            index = 0;
        }
        if (i < length) {
            int start = i;
            while (i < length) {
                state.buffer[index + i - start] = buffer[i + offset];
                ++i;
            }
        }
    }

    public void update(byte[] buffer, int offset, int length) {
        this.update(this.workingState, buffer, offset, length);
    }

    public void update(byte[] buffer, int length) {
        this.update(buffer, 0, length);
    }

    public void update(byte[] buffer) {
        this.update(buffer, 0, buffer.length);
    }

    public void update(byte b) {
        byte[] buffer = new byte[]{b};
        this.update(buffer, 1);
    }

    public void update(String s) {
        this.update(s.getBytes());
    }

    public void update(String s, String enc) throws UnsupportedEncodingException {
        this.update(s.getBytes(enc));
    }

    private static String toHex(byte[] hash) {
        StringBuilder buf = new StringBuilder(hash.length * 2);
        for (byte element : hash) {
            int intVal = element & 0xFF;
            if (intVal < 16) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(intVal));
        }
        return buf.toString();
    }

    private static int FF(int a, int b, int c, int d, int x, int s, int ac) {
        a += b & c | ~b & d;
        a += x;
        a += ac;
        a = a << s | a >>> 32 - s;
        return a + b;
    }

    private static int GG(int a, int b, int c, int d, int x, int s, int ac) {
        a += b & d | c & ~d;
        a += x;
        a += ac;
        a = a << s | a >>> 32 - s;
        return a + b;
    }

    private static int HH(int a, int b, int c, int d, int x, int s, int ac) {
        a += b ^ c ^ d;
        a += x;
        a += ac;
        a = a << s | a >>> 32 - s;
        return a + b;
    }

    private static int II(int a, int b, int c, int d, int x, int s, int ac) {
        a += c ^ (b | ~d);
        a += x;
        a += ac;
        a = a << s | a >>> 32 - s;
        return a + b;
    }

    private static byte[] encode(long l) {
        byte[] out = new byte[]{(byte)(l & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 56 & 0xFFL)};
        return out;
    }

    private static byte[] encode(int[] input, int len) {
        byte[] out = new byte[len];
        int i = 0;
        for (int j = 0; j < len; j += 4) {
            out[j] = (byte)(input[i] & 0xFF);
            out[j + 1] = (byte)(input[i] >>> 8 & 0xFF);
            out[j + 2] = (byte)(input[i] >>> 16 & 0xFF);
            out[j + 3] = (byte)(input[i] >>> 24 & 0xFF);
            ++i;
        }
        return out;
    }

    private int[] decode(byte[] buffer, int len, int offset) {
        int i = 0;
        for (int j = 0; j < len; j += 4) {
            this.decodeBuffer[i] = buffer[j + offset] & 0xFF | (buffer[j + 1 + offset] & 0xFF) << 8 | (buffer[j + 2 + offset] & 0xFF) << 16 | (buffer[j + 3 + offset] & 0xFF) << 24;
            ++i;
        }
        return this.decodeBuffer;
    }

    private static void transform(MD5State state, int[] x) {
        int a = state.state[0];
        int b = state.state[1];
        int c = state.state[2];
        int d = state.state[3];
        a = MD5.FF((int)a, (int)b, (int)c, (int)d, (int)x[0], (int)7, (int)-680876936);
        d = MD5.FF((int)d, (int)a, (int)b, (int)c, (int)x[1], (int)12, (int)-389564586);
        c = MD5.FF((int)c, (int)d, (int)a, (int)b, (int)x[2], (int)17, (int)606105819);
        b = MD5.FF((int)b, (int)c, (int)d, (int)a, (int)x[3], (int)22, (int)-1044525330);
        a = MD5.FF((int)a, (int)b, (int)c, (int)d, (int)x[4], (int)7, (int)-176418897);
        d = MD5.FF((int)d, (int)a, (int)b, (int)c, (int)x[5], (int)12, (int)1200080426);
        c = MD5.FF((int)c, (int)d, (int)a, (int)b, (int)x[6], (int)17, (int)-1473231341);
        b = MD5.FF((int)b, (int)c, (int)d, (int)a, (int)x[7], (int)22, (int)-45705983);
        a = MD5.FF((int)a, (int)b, (int)c, (int)d, (int)x[8], (int)7, (int)1770035416);
        d = MD5.FF((int)d, (int)a, (int)b, (int)c, (int)x[9], (int)12, (int)-1958414417);
        c = MD5.FF((int)c, (int)d, (int)a, (int)b, (int)x[10], (int)17, (int)-42063);
        b = MD5.FF((int)b, (int)c, (int)d, (int)a, (int)x[11], (int)22, (int)-1990404162);
        a = MD5.FF((int)a, (int)b, (int)c, (int)d, (int)x[12], (int)7, (int)1804603682);
        d = MD5.FF((int)d, (int)a, (int)b, (int)c, (int)x[13], (int)12, (int)-40341101);
        c = MD5.FF((int)c, (int)d, (int)a, (int)b, (int)x[14], (int)17, (int)-1502002290);
        b = MD5.FF((int)b, (int)c, (int)d, (int)a, (int)x[15], (int)22, (int)1236535329);
        a = MD5.GG((int)a, (int)b, (int)c, (int)d, (int)x[1], (int)5, (int)-165796510);
        d = MD5.GG((int)d, (int)a, (int)b, (int)c, (int)x[6], (int)9, (int)-1069501632);
        c = MD5.GG((int)c, (int)d, (int)a, (int)b, (int)x[11], (int)14, (int)643717713);
        b = MD5.GG((int)b, (int)c, (int)d, (int)a, (int)x[0], (int)20, (int)-373897302);
        a = MD5.GG((int)a, (int)b, (int)c, (int)d, (int)x[5], (int)5, (int)-701558691);
        d = MD5.GG((int)d, (int)a, (int)b, (int)c, (int)x[10], (int)9, (int)38016083);
        c = MD5.GG((int)c, (int)d, (int)a, (int)b, (int)x[15], (int)14, (int)-660478335);
        b = MD5.GG((int)b, (int)c, (int)d, (int)a, (int)x[4], (int)20, (int)-405537848);
        a = MD5.GG((int)a, (int)b, (int)c, (int)d, (int)x[9], (int)5, (int)568446438);
        d = MD5.GG((int)d, (int)a, (int)b, (int)c, (int)x[14], (int)9, (int)-1019803690);
        c = MD5.GG((int)c, (int)d, (int)a, (int)b, (int)x[3], (int)14, (int)-187363961);
        b = MD5.GG((int)b, (int)c, (int)d, (int)a, (int)x[8], (int)20, (int)1163531501);
        a = MD5.GG((int)a, (int)b, (int)c, (int)d, (int)x[13], (int)5, (int)-1444681467);
        d = MD5.GG((int)d, (int)a, (int)b, (int)c, (int)x[2], (int)9, (int)-51403784);
        c = MD5.GG((int)c, (int)d, (int)a, (int)b, (int)x[7], (int)14, (int)1735328473);
        b = MD5.GG((int)b, (int)c, (int)d, (int)a, (int)x[12], (int)20, (int)-1926607734);
        a = MD5.HH((int)a, (int)b, (int)c, (int)d, (int)x[5], (int)4, (int)-378558);
        d = MD5.HH((int)d, (int)a, (int)b, (int)c, (int)x[8], (int)11, (int)-2022574463);
        c = MD5.HH((int)c, (int)d, (int)a, (int)b, (int)x[11], (int)16, (int)1839030562);
        b = MD5.HH((int)b, (int)c, (int)d, (int)a, (int)x[14], (int)23, (int)-35309556);
        a = MD5.HH((int)a, (int)b, (int)c, (int)d, (int)x[1], (int)4, (int)-1530992060);
        d = MD5.HH((int)d, (int)a, (int)b, (int)c, (int)x[4], (int)11, (int)1272893353);
        c = MD5.HH((int)c, (int)d, (int)a, (int)b, (int)x[7], (int)16, (int)-155497632);
        b = MD5.HH((int)b, (int)c, (int)d, (int)a, (int)x[10], (int)23, (int)-1094730640);
        a = MD5.HH((int)a, (int)b, (int)c, (int)d, (int)x[13], (int)4, (int)681279174);
        d = MD5.HH((int)d, (int)a, (int)b, (int)c, (int)x[0], (int)11, (int)-358537222);
        c = MD5.HH((int)c, (int)d, (int)a, (int)b, (int)x[3], (int)16, (int)-722521979);
        b = MD5.HH((int)b, (int)c, (int)d, (int)a, (int)x[6], (int)23, (int)76029189);
        a = MD5.HH((int)a, (int)b, (int)c, (int)d, (int)x[9], (int)4, (int)-640364487);
        d = MD5.HH((int)d, (int)a, (int)b, (int)c, (int)x[12], (int)11, (int)-421815835);
        c = MD5.HH((int)c, (int)d, (int)a, (int)b, (int)x[15], (int)16, (int)530742520);
        b = MD5.HH((int)b, (int)c, (int)d, (int)a, (int)x[2], (int)23, (int)-995338651);
        a = MD5.II((int)a, (int)b, (int)c, (int)d, (int)x[0], (int)6, (int)-198630844);
        d = MD5.II((int)d, (int)a, (int)b, (int)c, (int)x[7], (int)10, (int)1126891415);
        c = MD5.II((int)c, (int)d, (int)a, (int)b, (int)x[14], (int)15, (int)-1416354905);
        b = MD5.II((int)b, (int)c, (int)d, (int)a, (int)x[5], (int)21, (int)-57434055);
        a = MD5.II((int)a, (int)b, (int)c, (int)d, (int)x[12], (int)6, (int)1700485571);
        d = MD5.II((int)d, (int)a, (int)b, (int)c, (int)x[3], (int)10, (int)-1894986606);
        c = MD5.II((int)c, (int)d, (int)a, (int)b, (int)x[10], (int)15, (int)-1051523);
        b = MD5.II((int)b, (int)c, (int)d, (int)a, (int)x[1], (int)21, (int)-2054922799);
        a = MD5.II((int)a, (int)b, (int)c, (int)d, (int)x[8], (int)6, (int)1873313359);
        d = MD5.II((int)d, (int)a, (int)b, (int)c, (int)x[15], (int)10, (int)-30611744);
        c = MD5.II((int)c, (int)d, (int)a, (int)b, (int)x[6], (int)15, (int)-1560198380);
        b = MD5.II((int)b, (int)c, (int)d, (int)a, (int)x[13], (int)21, (int)1309151649);
        a = MD5.II((int)a, (int)b, (int)c, (int)d, (int)x[4], (int)6, (int)-145523070);
        d = MD5.II((int)d, (int)a, (int)b, (int)c, (int)x[11], (int)10, (int)-1120210379);
        c = MD5.II((int)c, (int)d, (int)a, (int)b, (int)x[2], (int)15, (int)718787259);
        b = MD5.II((int)b, (int)c, (int)d, (int)a, (int)x[9], (int)21, (int)-343485551);
        state.state[0] = state.state[0] + a;
        state.state[1] = state.state[1] + b;
        state.state[2] = state.state[2] + c;
        state.state[3] = state.state[3] + d;
    }
}

