/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.users;

import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.flywaydb.core.Flyway;
import org.owasp.webgoat.container.lessons.Initializable;
import org.owasp.webgoat.container.users.UserProgress;
import org.owasp.webgoat.container.users.UserProgressRepository;
import org.owasp.webgoat.container.users.UserRepository;
import org.owasp.webgoat.container.users.WebGoatUser;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserService
implements UserDetailsService {
    private final UserRepository userRepository;
    private final UserProgressRepository userTrackerRepository;
    private final JdbcTemplate jdbcTemplate;
    private final Function<String, Flyway> flywayLessons;
    private final List<Initializable> lessonInitializables;

    public WebGoatUser loadUserByUsername(String username) throws UsernameNotFoundException {
        WebGoatUser webGoatUser = this.userRepository.findByUsername(username);
        if (webGoatUser == null) {
            throw new UsernameNotFoundException("User not found");
        }
        webGoatUser.createUser();
        this.lessonInitializables.forEach(l -> l.initialize(webGoatUser));
        return webGoatUser;
    }

    public void addUser(String username, String password) {
        boolean userAlreadyExists = this.userRepository.existsByUsername(username);
        WebGoatUser webGoatUser = (WebGoatUser)this.userRepository.save((Object)new WebGoatUser(username, password));
        if (!userAlreadyExists) {
            this.userTrackerRepository.save((Object)new UserProgress(username));
            this.createLessonsForUser(webGoatUser);
        }
    }

    private void createLessonsForUser(WebGoatUser webGoatUser) {
        this.jdbcTemplate.execute("CREATE SCHEMA \"" + webGoatUser.getUsername() + "\" authorization dba");
        ((Flyway)this.flywayLessons.apply(webGoatUser.getUsername())).migrate();
    }

    public List<WebGoatUser> getAllUsers() {
        return this.userRepository.findAll();
    }

    @Generated
    public UserService(UserRepository userRepository, UserProgressRepository userTrackerRepository, JdbcTemplate jdbcTemplate, Function<String, Flyway> flywayLessons, List<Initializable> lessonInitializables) {
        this.userRepository = userRepository;
        this.userTrackerRepository = userTrackerRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.flywayLessons = flywayLessons;
        this.lessonInitializables = lessonInitializables;
    }
}

