/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.users;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.owasp.webgoat.container.lessons.Lesson;
import org.owasp.webgoat.container.users.LessonProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class UserProgress {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserProgress.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="username")
    private String user;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private Set<LessonProgress> lessonProgress = new HashSet();

    protected UserProgress() {
    }

    public UserProgress(String user) {
        this.user = user;
    }

    public LessonProgress getLessonProgress(Lesson lesson) {
        Optional<LessonProgress> progress = this.lessonProgress.stream().filter(l -> l.getLessonName().equals(lesson.getId())).findFirst();
        if (!progress.isPresent()) {
            LessonProgress newLessonTracker = new LessonProgress(lesson);
            this.lessonProgress.add(newLessonTracker);
            return newLessonTracker;
        }
        return progress.get();
    }

    public Optional<LessonProgress> getLessonProgress(String id) {
        return this.lessonProgress.stream().filter(l -> l.getLessonName().equals(id)).findFirst();
    }

    public void assignmentSolved(Lesson lesson, String assignmentName) {
        LessonProgress progress = this.getLessonProgress(lesson);
        progress.incrementAttempts();
        progress.assignmentSolved(assignmentName);
    }

    public void assignmentFailed(Lesson lesson) {
        LessonProgress progress = this.getLessonProgress(lesson);
        progress.incrementAttempts();
    }

    public void reset(Lesson al) {
        LessonProgress progress = this.getLessonProgress(al);
        progress.reset();
    }

    public long numberOfLessonsSolved() {
        return this.lessonProgress.stream().filter(LessonProgress::isLessonSolved).count();
    }

    public long numberOfAssignmentsSolved() {
        return this.lessonProgress.stream().map(LessonProgress::numberOfSolvedAssignments).mapToLong(Long::valueOf).sum();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserProgress)) {
            return false;
        }
        UserProgress other = (UserProgress)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.id;
        Long other$id = other.id;
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$user = this.user;
        String other$user = other.user;
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        Set this$lessonProgress = this.lessonProgress;
        Set other$lessonProgress = other.lessonProgress;
        return !(this$lessonProgress == null ? other$lessonProgress != null : !((Object)this$lessonProgress).equals(other$lessonProgress));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserProgress;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.id;
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $user = this.user;
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        Set $lessonProgress = this.lessonProgress;
        result = result * 59 + ($lessonProgress == null ? 43 : ((Object)$lessonProgress).hashCode());
        return result;
    }
}

