/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.users;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.owasp.webgoat.container.i18n.PluginMessages;
import org.owasp.webgoat.container.lessons.Lesson;
import org.owasp.webgoat.container.session.Course;
import org.owasp.webgoat.container.users.LessonProgress;
import org.owasp.webgoat.container.users.Scoreboard;
import org.owasp.webgoat.container.users.UserProgress;
import org.owasp.webgoat.container.users.UserProgressRepository;
import org.owasp.webgoat.container.users.UserRepository;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class Scoreboard {
    private final UserProgressRepository userTrackerRepository;
    private final UserRepository userRepository;
    private final Course course;
    private final PluginMessages pluginMessages;

    @GetMapping(value={"/scoreboard-data"})
    public List<Ranking> getRankings() {
        return this.userRepository.findAll().stream().filter(user -> !user.getUsername().startsWith("csrf-")).map(user -> new Ranking(this, user.getUsername(), this.challengesSolved(this.userTrackerRepository.findByUser(user.getUsername())))).sorted((o1, o2) -> o2.getFlagsCaptured().size() - o1.getFlagsCaptured().size()).collect(Collectors.toList());
    }

    private List<String> challengesSolved(UserProgress userTracker) {
        List<String> challenges = List.of("Challenge1", "Challenge2", "Challenge3", "Challenge4", "Challenge5", "Challenge6", "Challenge7", "Challenge8", "Challenge9");
        return challenges.stream().map(arg_0 -> ((UserProgress)userTracker).getLessonProgress(arg_0)).flatMap(Optional::stream).filter(LessonProgress::isLessonSolved).map(LessonProgress::getLessonName).map(arg_0 -> this.toLessonTitle(arg_0)).toList();
    }

    private String toLessonTitle(String id) {
        String titleKey = this.course.getLessons().stream().filter(l -> l.getId().equals(id)).findFirst().map(Lesson::getTitle).orElse("No title");
        return this.pluginMessages.getMessage(titleKey, titleKey, new Object[0]);
    }

    @Generated
    public Scoreboard(UserProgressRepository userTrackerRepository, UserRepository userRepository, Course course, PluginMessages pluginMessages) {
        this.userTrackerRepository = userTrackerRepository;
        this.userRepository = userRepository;
        this.course = course;
        this.pluginMessages = pluginMessages;
    }
}

