/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.session;

import java.util.List;
import lombok.Generated;
import org.owasp.webgoat.container.lessons.Category;
import org.owasp.webgoat.container.lessons.Lesson;
import org.owasp.webgoat.container.lessons.LessonName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Course {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Course.class);
    private List<Lesson> lessons;

    public Course(List<Lesson> lessons) {
        this.lessons = lessons;
    }

    public List<Category> getCategories() {
        return this.lessons.parallelStream().map(Lesson::getCategory).distinct().sorted().toList();
    }

    public Lesson getFirstLesson() {
        return (Lesson)this.getLessons((Category)this.getCategories().get(0)).get(0);
    }

    public List<Lesson> getLessons() {
        return this.lessons;
    }

    public List<Lesson> getLessons(Category category) {
        return this.lessons.stream().filter(l -> l.getCategory() == category).toList();
    }

    public void setLessons(List<Lesson> lessons) {
        this.lessons = lessons;
    }

    public int getTotalOfLessons() {
        return this.lessons.size();
    }

    public int getTotalOfAssignments() {
        return this.lessons.stream().reduce(0, (total, lesson) -> lesson.getAssignments().size() + total, Integer::sum);
    }

    public Lesson getLessonByName(LessonName lessonName) {
        return this.lessons.stream().filter(lesson -> lesson.getName().equals((Object)lessonName)).findFirst().orElse(null);
    }

    public Lesson getLessonByAssignment(String assignmentName) {
        return this.lessons.stream().filter(lesson -> lesson.getAssignments().stream().anyMatch(assignment -> assignment.getName().equals(assignmentName))).findFirst().orElse(null);
    }
}

