/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.service;

import java.util.List;
import lombok.Generated;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.lessons.Lesson;
import org.owasp.webgoat.container.lessons.LessonName;
import org.owasp.webgoat.container.service.LessonProgressService;
import org.owasp.webgoat.container.session.Course;
import org.owasp.webgoat.container.users.AssignmentProgress;
import org.owasp.webgoat.container.users.LessonProgress;
import org.owasp.webgoat.container.users.UserProgress;
import org.owasp.webgoat.container.users.UserProgressRepository;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LessonProgressService {
    private final UserProgressRepository userProgressRepository;
    private final Course course;

    @GetMapping(value={"/service/lessonoverview.mvc/{lesson}"})
    @ResponseBody
    public List<LessonOverview> lessonOverview(@PathVariable(value="lesson") LessonName lessonName, @CurrentUsername String username) {
        UserProgress userProgress = this.userProgressRepository.findByUser(username);
        Lesson lesson = this.course.getLessonByName(lessonName);
        LessonProgress lessonProgress = userProgress.getLessonProgress(lesson);
        return lessonProgress.getLessonOverview().entrySet().stream().map(entry -> new LessonOverview(((AssignmentProgress)entry.getKey()).getAssignment(), (Boolean)entry.getValue())).toList();
    }

    @Generated
    public LessonProgressService(UserProgressRepository userProgressRepository, Course course) {
        this.userProgressRepository = userProgressRepository;
        this.course = course;
    }
}

