/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.lessons.Category;
import org.owasp.webgoat.container.lessons.Lesson;
import org.owasp.webgoat.container.lessons.LessonMenuItem;
import org.owasp.webgoat.container.lessons.LessonMenuItemType;
import org.owasp.webgoat.container.session.Course;
import org.owasp.webgoat.container.users.LessonProgress;
import org.owasp.webgoat.container.users.UserProgress;
import org.owasp.webgoat.container.users.UserProgressRepository;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LessonMenuService {
    public static final String URL_LESSONMENU_MVC = "/service/lessonmenu.mvc";
    private final Course course;
    private UserProgressRepository userTrackerRepository;
    @Value(value="#{'${exclude.categories}'.split(',')}")
    private List<String> excludeCategories;
    @Value(value="#{'${exclude.lessons}'.split(',')}")
    private List<String> excludeLessons;

    @RequestMapping(path={"/service/lessonmenu.mvc"}, produces={"application/json"})
    @ResponseBody
    public List<LessonMenuItem> showLeftNav(@CurrentUsername String username) {
        ArrayList<LessonMenuItem> menu = new ArrayList<LessonMenuItem>();
        List categories = this.course.getCategories();
        UserProgress userTracker = this.userTrackerRepository.findByUser(username);
        for (Category category : categories) {
            if (this.excludeCategories.contains(category.name())) continue;
            LessonMenuItem categoryItem = new LessonMenuItem();
            categoryItem.setName(category.getName());
            categoryItem.setType(LessonMenuItemType.CATEGORY);
            List<Lesson> lessons = this.course.getLessons(category);
            lessons = lessons.stream().sorted(Comparator.comparing(Lesson::getTitle)).toList();
            for (Lesson lesson : lessons) {
                if (this.excludeLessons.contains(lesson.getName())) continue;
                LessonMenuItem lessonItem = new LessonMenuItem();
                lessonItem.setName(lesson.getTitle());
                lessonItem.setLink(lesson.getLink());
                lessonItem.setType(LessonMenuItemType.LESSON);
                LessonProgress lessonTracker = userTracker.getLessonProgress(lesson);
                boolean lessonSolved = lessonTracker.isLessonSolved();
                lessonItem.setComplete(lessonSolved);
                categoryItem.addChild(lessonItem);
            }
            categoryItem.getChildren().sort(Comparator.comparingInt(LessonMenuItem::getRanking));
            menu.add(categoryItem);
        }
        return menu;
    }

    @Generated
    public LessonMenuService(Course course, UserProgressRepository userTrackerRepository, List<String> excludeCategories, List<String> excludeLessons) {
        this.course = course;
        this.userTrackerRepository = userTrackerRepository;
        this.excludeCategories = excludeCategories;
        this.excludeLessons = excludeLessons;
    }
}

