/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.service;

import java.util.Map;
import lombok.Generated;
import org.owasp.webgoat.container.session.LabelDebugger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LabelDebugService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LabelDebugService.class);
    private static final String URL_DEBUG_LABELS_MVC = "/service/debug/labels.mvc";
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_SUCCESS = "success";
    private LabelDebugger labelDebugger;

    @RequestMapping(path={"/service/debug/labels.mvc"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> checkDebuggingStatus() {
        log.debug("Checking label debugging, it is {}", (Object)this.labelDebugger.isEnabled());
        Map result = this.createResponse(Boolean.valueOf(this.labelDebugger.isEnabled()));
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/service/debug/labels.mvc"}, produces={"application/json"}, params={"enabled"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> setDebuggingStatus(@RequestParam(value="enabled") Boolean enabled) {
        log.debug("Setting label debugging to {} ", (Object)this.labelDebugger.isEnabled());
        Map result = this.createResponse(enabled);
        this.labelDebugger.setEnabled(enabled.booleanValue());
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }

    private Map<String, Object> createResponse(Boolean enabled) {
        return Map.of(KEY_SUCCESS, Boolean.TRUE, KEY_ENABLED, enabled);
    }

    @Generated
    public LabelDebugService(LabelDebugger labelDebugger) {
        this.labelDebugger = labelDebugger;
    }
}

