/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.report;

import java.util.List;
import org.owasp.webgoat.container.CurrentUsername;
import org.owasp.webgoat.container.i18n.PluginMessages;
import org.owasp.webgoat.container.report.ReportCardController;
import org.owasp.webgoat.container.session.Course;
import org.owasp.webgoat.container.users.LessonProgress;
import org.owasp.webgoat.container.users.UserProgress;
import org.owasp.webgoat.container.users.UserProgressRepository;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ReportCardController {
    private final UserProgressRepository userProgressRepository;
    private final Course course;
    private final PluginMessages pluginMessages;

    public ReportCardController(UserProgressRepository userProgressRepository, Course course, PluginMessages pluginMessages) {
        this.userProgressRepository = userProgressRepository;
        this.course = course;
        this.pluginMessages = pluginMessages;
    }

    @GetMapping(path={"/service/reportcard.mvc"}, produces={"application/json"})
    @ResponseBody
    public ReportCard reportCard(@CurrentUsername String username) {
        UserProgress userProgress = this.userProgressRepository.findByUser(username);
        List<LessonStatistics> lessonStatistics = this.course.getLessons().stream().map(lesson -> {
            LessonProgress lessonTracker = userProgress.getLessonProgress(lesson);
            return new LessonStatistics(this.pluginMessages.getMessage(lesson.getTitle(), new Object[0]), lessonTracker.isLessonSolved(), lessonTracker.getNumberOfAttempts());
        }).toList();
        return new ReportCard(this.course.getTotalOfLessons(), this.course.getTotalOfAssignments(), userProgress.numberOfAssignmentsSolved(), userProgress.numberOfLessonsSolved(), lessonStatistics);
    }
}

