/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.lessons;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.owasp.webgoat.container.lessons.Assignment;
import org.owasp.webgoat.container.lessons.Category;
import org.owasp.webgoat.container.lessons.LessonName;

public abstract class Lesson {
    private List<Assignment> assignments = new ArrayList();

    public void addAssignment(Assignment assignment) {
        this.assignments.add(assignment);
    }

    public LessonName getName() {
        String className = this.getClass().getName();
        return new LessonName(className.substring(className.lastIndexOf(46) + 1));
    }

    public Category getCategory() {
        return this.getDefaultCategory();
    }

    protected abstract Category getDefaultCategory();

    public abstract String getTitle();

    protected String getPath() {
        return "#lesson/";
    }

    public String getLink() {
        return String.format("%s%s.lesson", this.getPath(), this.getId());
    }

    public String toString() {
        return this.getTitle();
    }

    public final String getId() {
        return this.getClass().getSimpleName();
    }

    public final String getPackage() {
        String packageName = this.getClass().getPackageName();
        return packageName.replaceAll("org.owasp.webgoat.lessons.", "").replaceAll("\\..*", "");
    }

    @Generated
    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    @Generated
    public void setAssignments(List<Assignment> assignments) {
        this.assignments = assignments;
    }
}

