/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.lessons;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AssignmentHints;
import org.owasp.webgoat.container.assignments.AttackResult;
import org.owasp.webgoat.container.lessons.Assignment;
import org.owasp.webgoat.container.lessons.Lesson;
import org.owasp.webgoat.container.session.Course;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Configuration
public class CourseConfiguration {
    private final List<Lesson> lessons;
    private final List<AssignmentEndpoint> assignments;
    private final String contextPath;

    public CourseConfiguration(List<Lesson> lessons, List<AssignmentEndpoint> assignments, @Value(value="${server.servlet.context-path}") String contextPath) {
        this.lessons = lessons;
        this.assignments = assignments;
        this.contextPath = contextPath.equals("/") ? "" : contextPath;
    }

    private void attachToLessonInParentPackage(AssignmentEndpoint assignmentEndpoint, String packageName) {
        if (packageName.equals("org.owasp.webgoat.lessons")) {
            throw new IllegalStateException("No lesson found for assignment: '%s'".formatted(assignmentEndpoint.getClass().getSimpleName()));
        }
        this.lessons.stream().filter(l -> l.getClass().getPackageName().equals(packageName)).findFirst().ifPresentOrElse(l -> l.addAssignment(this.toAssignment(assignmentEndpoint)), () -> this.attachToLessonInParentPackage(assignmentEndpoint, packageName.substring(0, packageName.lastIndexOf("."))));
    }

    private void attachToLesson(AssignmentEndpoint assignmentEndpoint) {
        this.lessons.stream().filter(l -> l.getClass().getPackageName().equals(assignmentEndpoint.getClass().getPackageName())).findFirst().ifPresentOrElse(l -> l.addAssignment(this.toAssignment(assignmentEndpoint)), () -> {
            String assignmentPackageName = assignmentEndpoint.getClass().getPackageName();
            this.attachToLessonInParentPackage(assignmentEndpoint, assignmentPackageName.substring(0, assignmentPackageName.lastIndexOf(".")));
        });
    }

    private Assignment toAssignment(AssignmentEndpoint endpoint) {
        return new Assignment(endpoint.getClass().getSimpleName(), this.getPath(endpoint.getClass()), this.getHints(endpoint.getClass()));
    }

    @Bean
    public Course course() {
        this.assignments.forEach(arg_0 -> this.attachToLesson(arg_0));
        int assignmentsAttachedToLessons = this.lessons.stream().mapToInt(l -> l.getAssignments().size()).sum();
        Assert.isTrue((assignmentsAttachedToLessons == this.assignments.size() ? 1 : 0) != 0, (String)("Not all assignments are attached to a lesson, please check the configuration. The following assignments are not attached to any lesson: " + String.valueOf(this.findDiff())));
        return new Course(this.lessons);
    }

    private List<String> findDiff() {
        List<String> matchedToLessons = this.lessons.stream().flatMap(l -> l.getAssignments().stream()).map(Assignment::getName).toList();
        List<String> allAssignments = this.assignments.stream().map(a -> a.getClass().getSimpleName()).toList();
        ArrayList<String> diff = new ArrayList<String>(allAssignments);
        diff.removeAll(matchedToLessons);
        return diff;
    }

    private String getPath(Class<? extends AssignmentEndpoint> e) {
        for (Method m : e.getMethods()) {
            String mapping;
            if (!this.methodReturnTypeIsOfTypeAttackResult(m) || (mapping = this.getMapping(m)) == null) continue;
            return this.contextPath + mapping;
        }
        throw new IllegalStateException("Assignment endpoint: " + String.valueOf(e) + " has no mapping like @GetMapping/@PostMapping etc,with return type 'AttackResult' or 'ResponseEntity<AttackResult>' please consider adding one");
    }

    private boolean methodReturnTypeIsOfTypeAttackResult(Method m) {
        if (m.getReturnType() == AttackResult.class) {
            return true;
        }
        Type genericType = m.getGenericReturnType();
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)m.getGenericReturnType()).getActualTypeArguments()[0] == AttackResult.class;
        }
        return false;
    }

    private String getMapping(Method m) {
        String[] paths = null;
        if (m.getAnnotation(RequestMapping.class) != null) {
            paths = (String[])ArrayUtils.addAll((Object[])m.getAnnotation(RequestMapping.class).value(), (Object[])m.getAnnotation(RequestMapping.class).path());
        } else if (m.getAnnotation(PostMapping.class) != null) {
            paths = (String[])ArrayUtils.addAll((Object[])m.getAnnotation(PostMapping.class).value(), (Object[])m.getAnnotation(PostMapping.class).path());
        } else if (m.getAnnotation(GetMapping.class) != null) {
            paths = (String[])ArrayUtils.addAll((Object[])m.getAnnotation(GetMapping.class).value(), (Object[])m.getAnnotation(GetMapping.class).path());
        } else if (m.getAnnotation(PutMapping.class) != null) {
            paths = (String[])ArrayUtils.addAll((Object[])m.getAnnotation(PutMapping.class).value(), (Object[])m.getAnnotation(PutMapping.class).path());
        }
        if (paths == null) {
            return null;
        }
        return Arrays.stream(paths).filter(path -> !"".equals(path)).findFirst().orElse("");
    }

    private List<String> getHints(Class<? extends AssignmentEndpoint> e) {
        if (e.isAnnotationPresent(AssignmentHints.class)) {
            return List.of(((AssignmentHints[])e.getAnnotationsByType(AssignmentHints.class))[0].value());
        }
        return Collections.emptyList();
    }
}

