/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.assignments;

import org.owasp.webgoat.container.assignments.AssignmentEndpoint;
import org.owasp.webgoat.container.assignments.AttackResult;

public class AttackResultBuilder {
    private boolean assignmentCompleted;
    private Object[] feedbackArgs;
    private String feedbackResourceBundleKey;
    private String output;
    private Object[] outputArgs;
    private AssignmentEndpoint assignment;
    private boolean attemptWasMade = false;

    public AttackResultBuilder assignmentCompleted(boolean lessonCompleted) {
        this.assignmentCompleted = lessonCompleted;
        return this;
    }

    public AttackResultBuilder feedbackArgs(Object ... args) {
        this.feedbackArgs = args;
        return this;
    }

    public AttackResultBuilder feedback(String resourceBundleKey) {
        this.feedbackResourceBundleKey = resourceBundleKey;
        return this;
    }

    public AttackResultBuilder output(String output) {
        this.output = output;
        return this;
    }

    public AttackResultBuilder outputArgs(Object ... args) {
        this.outputArgs = args;
        return this;
    }

    public AttackResultBuilder attemptWasMade() {
        this.attemptWasMade = true;
        return this;
    }

    public AttackResult build() {
        return new AttackResult(this.assignmentCompleted, this.feedbackResourceBundleKey, this.feedbackArgs, this.output, this.outputArgs, this.assignment.getClass().getSimpleName(), this.attemptWasMade);
    }

    public AttackResultBuilder assignment(AssignmentEndpoint assignment) {
        this.assignment = assignment;
        return this;
    }

    public static AttackResultBuilder success(AssignmentEndpoint assignment) {
        return new AttackResultBuilder().assignmentCompleted(true).attemptWasMade().feedback("assignment.solved").assignment(assignment);
    }

    public static AttackResultBuilder failed(AssignmentEndpoint assignment) {
        return new AttackResultBuilder().assignmentCompleted(false).attemptWasMade().feedback("assignment.not.solved").assignment(assignment);
    }

    public static AttackResultBuilder informationMessage(AssignmentEndpoint assignment) {
        return new AttackResultBuilder().assignmentCompleted(false).assignment(assignment);
    }
}

