/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.assignments;

import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.owasp.webgoat.container.i18n.PluginMessages;

public class AttackResult {
    private final boolean lessonCompleted;
    private final String feedback;
    private Object[] feedbackArgs;
    private final String output;
    private Object[] outputArgs;
    private final String assignment;
    private final boolean attemptWasMade;

    private AttackResult(boolean lessonCompleted, String feedback, String output, String assignment, boolean attemptWasMade) {
        this.lessonCompleted = lessonCompleted;
        this.feedback = StringEscapeUtils.escapeJson((String)feedback);
        this.output = StringEscapeUtils.escapeJson((String)output);
        this.assignment = assignment;
        this.attemptWasMade = attemptWasMade;
    }

    public AttackResult(boolean lessonCompleted, String feedback, Object[] feedbackArgs, String output, Object[] outputArgs, String assignment, boolean attemptWasMade) {
        this.lessonCompleted = lessonCompleted;
        this.feedback = feedback;
        this.feedbackArgs = feedbackArgs;
        this.output = output;
        this.outputArgs = outputArgs;
        this.assignment = assignment;
        this.attemptWasMade = attemptWasMade;
    }

    public boolean assignmentSolved() {
        return this.lessonCompleted;
    }

    public AttackResult apply(PluginMessages pluginMessages) {
        return new AttackResult(this.lessonCompleted, pluginMessages.getMessage(this.feedback, this.feedback, this.feedbackArgs), pluginMessages.getMessage(this.output, this.output, this.outputArgs), this.assignment, this.attemptWasMade);
    }

    @Generated
    public boolean isLessonCompleted() {
        return this.lessonCompleted;
    }

    @Generated
    public String getFeedback() {
        return this.feedback;
    }

    @Generated
    public Object[] getFeedbackArgs() {
        return this.feedbackArgs;
    }

    @Generated
    public String getOutput() {
        return this.output;
    }

    @Generated
    public Object[] getOutputArgs() {
        return this.outputArgs;
    }

    @Generated
    public String getAssignment() {
        return this.assignment;
    }

    @Generated
    public boolean isAttemptWasMade() {
        return this.attemptWasMade;
    }
}

