/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container.asciidoc;

import java.util.HashMap;
import java.util.Map;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.ast.PhraseNode;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.extension.InlineMacroProcessor;
import org.owasp.webgoat.container.asciidoc.EnvironmentExposure;
import org.springframework.core.env.Environment;

public class WebWolfMacro
extends InlineMacroProcessor {
    public WebWolfMacro(String macroName) {
        super(macroName);
    }

    public WebWolfMacro(String macroName, Map<String, Object> config) {
        super(macroName, config);
    }

    public PhraseNode process(StructuralNode contentNode, String linkText, Map<String, Object> attributes) {
        Environment env = EnvironmentExposure.getEnv();
        String hostname = env.getProperty("webwolf.url");
        String target = (String)attributes.getOrDefault("target", "home");
        String href = hostname + "/" + target;
        if (this.displayCompleteLinkNoFormatting(attributes)) {
            linkText = href;
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("type", ":link");
        options.put("target", href);
        attributes.put("window", "_blank");
        return this.createPhraseNode((ContentNode)contentNode, "anchor", (String)linkText, attributes, options);
    }

    private boolean displayCompleteLinkNoFormatting(Map<String, Object> attributes) {
        return attributes.values().stream().anyMatch(a -> a.equals("noLink"));
    }
}

