/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.owasp.webgoat.container.asciidoc.EnvironmentExposure;
import org.springframework.core.env.Environment;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class UserInterceptor
implements HandlerInterceptor {
    private Environment env = EnvironmentExposure.getEnv();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (null != modelAndView) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (null != authentication) {
                modelAndView.getModel().put("username", authentication.getName());
            }
            if (null != this.env) {
                String githubClientId = this.env.getProperty("spring.security.oauth2.client.registration.github.client-id");
                if (null != githubClientId && !githubClientId.equals("dummy")) {
                    modelAndView.getModel().put("oauth", Boolean.TRUE);
                }
            } else {
                modelAndView.getModel().put("oauth", Boolean.FALSE);
            }
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

