/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class LessonResourceScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LessonResourceScanner.class);
    private static final Pattern lessonPattern = Pattern.compile("^.*/lessons/([^/]*)/.*$");
    private final Set<String> lessons = new HashSet();

    public LessonResourceScanner(ResourcePatternResolver resourcePatternResolver) {
        try {
            Resource[] resources;
            for (Resource resource : resources = resourcePatternResolver.getResources("classpath:/lessons/*/*")) {
                URL url = resource.getURL();
                Matcher matcher = lessonPattern.matcher(url.toString());
                if (!matcher.matches()) continue;
                this.lessons.add(matcher.group(1));
            }
            log.debug("Found {} lessons", (Object)this.lessons.size());
        }
        catch (IOException e) {
            log.warn("No lessons found...");
        }
    }

    public List<String> applyPattern(String pattern) {
        return this.lessons.stream().map(lesson -> String.format(pattern, lesson)).toList();
    }

    @Generated
    public Set<String> getLessons() {
        return this.lessons;
    }
}

