/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.owasp.webgoat.container.lessons.LessonConnectionInvocationHandler;
import org.springframework.jdbc.datasource.ConnectionProxy;

public class LessonDataSource
implements DataSource {
    private final DataSource originalDataSource;

    public LessonDataSource(DataSource dataSource) {
        this.originalDataSource = dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection targetConnection = this.originalDataSource.getConnection();
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new LessonConnectionInvocationHandler(targetConnection));
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.originalDataSource.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.originalDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.originalDataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.originalDataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.originalDataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.originalDataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return this.originalDataSource.unwrap(clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return this.originalDataSource.isWrapperFor(clazz);
    }
}

