/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webgoat.container;

import java.util.Map;
import java.util.function.Function;
import javax.sql.DataSource;
import lombok.Generated;
import org.flywaydb.core.Flyway;
import org.owasp.webgoat.container.LessonDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

@Configuration
public class DatabaseConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseConfiguration.class);
    private final DataSourceProperties properties;

    @Bean
    @Primary
    public DataSource dataSource() {
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(this.properties.getDriverClassName());
        dataSource.setUrl(this.properties.getUrl());
        dataSource.setUsername(this.properties.getUsername());
        dataSource.setPassword(this.properties.getPassword());
        return dataSource;
    }

    @Bean(initMethod="migrate")
    public Flyway flyWayContainer() {
        return Flyway.configure().configuration(Map.of("driver", this.properties.getDriverClassName())).dataSource(this.dataSource()).schemas(new String[]{"container"}).locations(new String[]{"db/container"}).load();
    }

    @Bean
    public Function<String, Flyway> flywayLessons() {
        return schema -> Flyway.configure().configuration(Map.of("driver", this.properties.getDriverClassName())).schemas(new String[]{schema}).cleanDisabled(false).dataSource(this.dataSource()).locations(new String[]{"lessons"}).load();
    }

    @Bean
    public LessonDataSource lessonDataSource(DataSource dataSource) {
        return new LessonDataSource(dataSource);
    }

    @Generated
    public DatabaseConfiguration(DataSourceProperties properties) {
        this.properties = properties;
    }
}

